/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.item;

import java.util.List;
import java.util.OptionalInt;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.Pair;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.CustomModelData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public final class CustomItemTranslator {
    public static @Nullable ItemDefinition getCustomItem(DataComponents components, ItemMapping mapping) {
        if (components == null) {
            return null;
        }
        List<Pair<CustomItemOptions, ItemDefinition>> customMappings = mapping.getCustomItemOptions();
        if (customMappings.isEmpty()) {
            return null;
        }
        float customModelDataInt = 0.0f;
        CustomModelData customModelData = components.get(DataComponentTypes.CUSTOM_MODEL_DATA);
        if (customModelData != null && !customModelData.floats().isEmpty()) {
            customModelDataInt = customModelData.floats().get(0).floatValue();
        }
        boolean checkDamage = mapping.getJavaItem().defaultMaxDamage() > 0;
        int damage = !checkDamage ? 0 : components.getOrDefault(DataComponentTypes.DAMAGE, 0);
        boolean unbreakable = checkDamage && !CustomItemTranslator.isDamaged(components, damage);
        for (Pair<CustomItemOptions, ItemDefinition> mappingTypes : customMappings) {
            OptionalInt damagePredicate;
            CustomItemOptions options = mappingTypes.key();
            if (!checkDamage ? options.unbreakable() != TriState.NOT_SET || options.damagePredicate().isPresent() : unbreakable && options.unbreakable() == TriState.FALSE || (damagePredicate = options.damagePredicate()).isPresent() && damage < damagePredicate.getAsInt()) continue;
            OptionalInt customModelDataOption = options.customModelData();
            if (customModelDataOption.isPresent() && customModelDataInt < (float)customModelDataOption.getAsInt()) continue;
            if (options.defaultItem()) {
                return null;
            }
            return mappingTypes.value();
        }
        return null;
    }

    private static boolean isDamaged(DataComponents components, int damage) {
        return CustomItemTranslator.isDamagableItem(components) && damage > 0;
    }

    private static boolean isDamagableItem(DataComponents components) {
        return components.get(DataComponentTypes.UNBREAKABLE) == null;
    }

    private CustomItemTranslator() {
    }
}

