/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.OptionalInt;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.BeaconPaymentAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.geysermc.geyser.inventory.BeaconContainer;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.holder.BlockInventoryHolder;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.IntSets;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSetBeaconPacket;

public class BeaconInventoryTranslator
extends AbstractBlockInventoryTranslator<BeaconContainer> {
    public BeaconInventoryTranslator() {
        super(1, new BlockInventoryHolder(Blocks.BEACON, org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType.BEACON, new Block[0]){

            @Override
            protected boolean checkInteractionPosition(GeyserSession session) {
                return true;
            }

            @Override
            public void openInventory(GeyserSession session, Container container) {
                if (!container.isUsingRealBlock()) {
                    InventoryUtils.closeInventory(session, container.getJavaId(), false);
                    return;
                }
                super.openInventory(session, container);
            }
        }, UIInventoryUpdater.INSTANCE);
    }

    @Override
    public void updateProperty(GeyserSession session, BeaconContainer container, int key, int value) {
        switch (key) {
            case 0: {
                break;
            }
            case 1: {
                container.setPrimaryId(value == -1 ? 0 : value);
                break;
            }
            case 2: {
                container.setSecondaryId(value == -1 ? 0 : value);
            }
        }
        Vector3i position = container.getHolderPosition();
        NbtMapBuilder builder = BlockEntityTranslator.getConstantBedrockTag("Beacon", position).putString("CustomName", container.getTitle()).putInt("primary", container.getPrimaryId()).putInt("secondary", container.getSecondaryId());
        BlockEntityDataPacket packet = new BlockEntityDataPacket();
        packet.setBlockPosition(position);
        packet.setData(builder.build());
        session.sendUpstreamPacket(packet);
    }

    @Override
    protected boolean shouldHandleRequestFirst(ItemStackRequestAction action, BeaconContainer container) {
        return action.getType() == ItemStackRequestActionType.BEACON_PAYMENT;
    }

    @Override
    public ItemStackResponse translateSpecialRequest(GeyserSession session, BeaconContainer container, ItemStackRequest request) {
        BeaconPaymentAction beaconPayment = (BeaconPaymentAction)request.getActions()[0];
        ServerboundSetBeaconPacket packet = new ServerboundSetBeaconPacket(this.toJava(beaconPayment.getPrimaryEffect()), this.toJava(beaconPayment.getSecondaryEffect()));
        session.sendDownstreamGamePacket(packet);
        return BeaconInventoryTranslator.acceptRequest(request, this.makeContainerEntries(session, container, IntSets.emptySet()));
    }

    private OptionalInt toJava(int effectChoice) {
        return effectChoice == 0 ? OptionalInt.empty() : OptionalInt.of(effectChoice - 1);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        if (slotInfoData.getContainerName().getContainer() == ContainerSlotType.BEACON_PAYMENT) {
            return 0;
        }
        return super.bedrockSlotToJava(slotInfoData);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot, BeaconContainer container) {
        if (slot == 0) {
            return new BedrockContainerSlot(ContainerSlotType.BEACON_PAYMENT, 27);
        }
        return super.javaSlotToBedrockContainer(slot, container);
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        if (slot == 0) {
            return 27;
        }
        return super.javaSlotToBedrock(slot);
    }

    @Override
    public BeaconContainer createInventory(GeyserSession session, String name, int windowId, ContainerType containerType) {
        return new BeaconContainer(session, name, windowId, this.size, containerType);
    }

    @Override
    public org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType closeContainerType(BeaconContainer container) {
        return null;
    }
}

