/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakClientChannel;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakPong;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.AdvancedChannelInboundHandler;

public class UnconnectedPongDecoder
extends AdvancedChannelInboundHandler<DatagramPacket> {
    public static final String NAME = "rak-unconnected-pong-deencoder";
    private final RakClientChannel channel;

    public UnconnectedPongDecoder(RakClientChannel channel) {
        this.channel = channel;
    }

    @Override
    protected boolean acceptInboundMessage(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!super.acceptInboundMessage(ctx, msg)) {
            return false;
        }
        DatagramPacket packet = (DatagramPacket)msg;
        ByteBuf buf = (ByteBuf)packet.content();
        return buf.isReadable() && buf.getUnsignedByte(buf.readerIndex()) == 28;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        ByteBuf buf = (ByteBuf)packet.content();
        buf.readUnsignedByte();
        long pingTime = buf.readLong();
        long guid = buf.readLong();
        ByteBuf magicBuf = (ByteBuf)this.channel.config().getOption(RakChannelOption.RAK_UNCONNECTED_MAGIC);
        if (!buf.isReadable(magicBuf.readableBytes()) || !ByteBufUtil.equals((ByteBuf)buf.readSlice(magicBuf.readableBytes()), (ByteBuf)magicBuf)) {
            return;
        }
        ByteBuf pongData = Unpooled.EMPTY_BUFFER;
        if (buf.isReadable(2)) {
            pongData = buf.readRetainedSlice(buf.readUnsignedShort());
        }
        ctx.fireChannelRead((Object)new RakPong(pingTime, guid, pongData, (InetSocketAddress)packet.sender()));
    }
}

