/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.proxy.ProxyChannel;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakChannel;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakChildChannel;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.config.DefaultRakServerConfig;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.config.RakServerChannelConfig;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common.UnconnectedPongEncoder;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.server.RakServerOfflineHandler;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.server.RakServerRateLimiter;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.server.RakServerRouteHandler;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.server.RakServerTailHandler;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.util.RakUtils;

public class RakServerChannel
extends ProxyChannel<DatagramChannel>
implements ServerChannel {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakServerChannel.class);
    private final RakServerChannelConfig config;
    private final Map<SocketAddress, RakChildChannel> childChannelMap = new ConcurrentHashMap<SocketAddress, RakChildChannel>();
    private final Consumer<RakChannel> childConsumer;

    public RakServerChannel(DatagramChannel channel) {
        this(channel, null);
    }

    public RakServerChannel(DatagramChannel channel, Consumer<RakChannel> childConsumer) {
        super(channel);
        this.childConsumer = childConsumer;
        this.config = new DefaultRakServerConfig(this);
        this.pipeline().addLast("rak-unconnected-pong-encoder", (ChannelHandler)UnconnectedPongEncoder.INSTANCE);
        if (this.config().getPacketLimit() > 0) {
            this.pipeline().addLast("rak-server-rate-limiter", (ChannelHandler)new RakServerRateLimiter(this));
        }
        this.pipeline().addLast("rak-offline-handler", (ChannelHandler)new RakServerOfflineHandler(this));
        this.pipeline().addLast("rak-server-route-handler", (ChannelHandler)new RakServerRouteHandler(this));
        this.pipeline().addLast("rak-server-tail-handler", (ChannelHandler)RakServerTailHandler.INSTANCE);
    }

    public RakChildChannel createChildChannel(InetSocketAddress address, InetSocketAddress localAddress, long clientGuid, int protocolVersion, int mtu) {
        RakChildChannel existingChannel = this.childChannelMap.get(address);
        if (this.config().getSendCookie() && existingChannel != null) {
            existingChannel.close();
        } else if (existingChannel != null) {
            return null;
        }
        RakChildChannel channel = new RakChildChannel(address, localAddress, this, clientGuid, protocolVersion, mtu, this.childConsumer);
        channel.closeFuture().addListener(this::onChildClosed);
        this.pipeline().fireChannelRead((Object)channel).fireChannelReadComplete();
        this.childChannelMap.put(address, channel);
        if (this.config().getMetrics() != null) {
            this.config().getMetrics().channelOpen(address);
        }
        return channel;
    }

    public RakChildChannel getChildChannel(SocketAddress address) {
        return this.childChannelMap.get(address);
    }

    private void onChildClosed(ChannelFuture channelFuture) {
        RakChildChannel channel = (RakChildChannel)channelFuture.channel();
        this.childChannelMap.remove(channel.remoteAddress());
        if (this.config().getMetrics() != null) {
            this.config().getMetrics().channelClose(channel.remoteAddress());
        }
        channel.rakPipeline().fireChannelInactive();
        channel.rakPipeline().fireChannelUnregistered();
        RakUtils.destroyChannelPipeline(channel.rakPipeline());
    }

    @Override
    public void onCloseTriggered(ChannelPromise promise) {
        if (log.isTraceEnabled()) {
            log.trace("Closing RakServerChannel: {}", (Object)Thread.currentThread().getName(), (Object)new Throwable());
        }
        PromiseCombiner combiner = new PromiseCombiner((EventExecutor)this.eventLoop());
        this.childChannelMap.values().forEach(channel -> combiner.add((Future)channel.close()));
        ChannelPromise combinedPromise = this.newPromise();
        combinedPromise.addListener(future -> super.onCloseTriggered(promise));
        combiner.finish((Promise)combinedPromise);
    }

    public boolean tryBlockAddress(InetAddress address, long time, TimeUnit unit) {
        RakServerRateLimiter rateLimiter = (RakServerRateLimiter)this.pipeline().get(RakServerRateLimiter.class);
        if (rateLimiter != null) {
            return rateLimiter.blockAddress(address, time, unit);
        }
        return false;
    }

    @Override
    public RakServerChannelConfig config() {
        return this.config;
    }
}

