/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.hashing.data;

import org.geysermc.geyser.item.hashing.MapBuilder;
import org.geysermc.geyser.item.hashing.MinecraftHasher;
import org.geysermc.geyser.item.hashing.RegistryHasher;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ConsumeEffect;

public enum ConsumeEffectType {
    APPLY_EFFECTS(ConsumeEffect.ApplyEffects.class, builder -> builder.acceptList("effects", RegistryHasher.MOB_EFFECT_INSTANCE, ConsumeEffect.ApplyEffects::effects).optional("probability", MinecraftHasher.FLOAT, ConsumeEffect.ApplyEffects::probability, Float.valueOf(1.0f))),
    REMOVE_EFFECTS(ConsumeEffect.RemoveEffects.class, builder -> builder.accept("effects", RegistryHasher.EFFECT_ID.holderSet(), ConsumeEffect.RemoveEffects::effects)),
    CLEAR_ALL_EFFECTS(ConsumeEffect.ClearAllEffects.class),
    TELEPORT_RANDOMLY(ConsumeEffect.TeleportRandomly.class, builder -> builder.optional("diameter", MinecraftHasher.FLOAT, ConsumeEffect.TeleportRandomly::diameter, Float.valueOf(16.0f))),
    PLAY_SOUND(ConsumeEffect.PlaySound.class, builder -> builder.accept("sound", RegistryHasher.SOUND_EVENT, ConsumeEffect.PlaySound::sound));

    private final Class<? extends ConsumeEffect> clazz;
    private final MapBuilder<? extends ConsumeEffect> builder;

    private <T extends ConsumeEffect> ConsumeEffectType(Class<T> clazz) {
        this.clazz = clazz;
        this.builder = MapBuilder.empty();
    }

    private <T extends ConsumeEffect> ConsumeEffectType(Class<T> clazz, MapBuilder<T> builder) {
        this.clazz = clazz;
        this.builder = builder;
    }

    public static ConsumeEffectType fromEffect(ConsumeEffect effect) {
        Class<?> clazz = effect.getClass();
        for (ConsumeEffectType type : ConsumeEffectType.values()) {
            if (clazz != type.clazz) continue;
            return type;
        }
        throw new IllegalStateException("Unimplemented consume effect type for hashing");
    }

    public MapBuilder<? extends ConsumeEffect> getBuilder() {
        return this.builder;
    }
}

