/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.entity.properties.type.BooleanProperty;
import org.geysermc.geyser.entity.properties.type.EnumProperty;
import org.geysermc.geyser.entity.properties.type.FloatProperty;
import org.geysermc.geyser.entity.properties.type.IntProperty;
import org.geysermc.geyser.entity.properties.type.PropertyType;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class GeyserEntityProperties {
    private final ObjectArrayList<PropertyType> properties;
    private final Object2IntMap<String> propertyIndices;

    private GeyserEntityProperties(ObjectArrayList<PropertyType> properties, Object2IntMap<String> propertyIndices) {
        this.properties = properties;
        this.propertyIndices = propertyIndices;
    }

    public NbtMap toNbtMap(String entityType) {
        NbtMapBuilder mapBuilder = NbtMap.builder();
        ArrayList<NbtMap> nbtProperties = new ArrayList<NbtMap>();
        for (PropertyType property : this.properties) {
            nbtProperties.add(property.nbtMap());
        }
        mapBuilder.putList("properties", NbtType.COMPOUND, nbtProperties);
        return mapBuilder.putString("type", entityType).build();
    }

    public @NonNull List<PropertyType> getProperties() {
        return this.properties;
    }

    public int getPropertyIndex(String name) {
        return this.propertyIndices.getOrDefault((Object)name, -1);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserEntityProperties)) {
            return false;
        }
        GeyserEntityProperties other = (GeyserEntityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PropertyType> this$properties = this.getProperties();
        List<PropertyType> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Object2IntMap<String> this$propertyIndices = this.propertyIndices;
        Object2IntMap<String> other$propertyIndices = other.propertyIndices;
        return !(this$propertyIndices == null ? other$propertyIndices != null : !this$propertyIndices.equals(other$propertyIndices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeyserEntityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PropertyType> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Object2IntMap<String> $propertyIndices = this.propertyIndices;
        result = result * 59 + ($propertyIndices == null ? 43 : $propertyIndices.hashCode());
        return result;
    }

    public String toString() {
        return "GeyserEntityProperties(properties=" + String.valueOf(this.getProperties()) + ", propertyIndices=" + String.valueOf(this.propertyIndices) + ")";
    }

    public static class Builder {
        private final ObjectArrayList<PropertyType> properties = new ObjectArrayList();
        private final Object2IntMap<String> propertyIndices = new Object2IntOpenHashMap<String>();

        public Builder addInt(@NonNull String name, int min, int max) {
            if (this.propertyIndices.containsKey(name)) {
                throw new IllegalArgumentException("Property with name " + name + " already exists on builder!");
            }
            IntProperty property = new IntProperty(name, min, max);
            this.properties.add(property);
            this.propertyIndices.put(name, this.properties.size() - 1);
            return this;
        }

        public Builder addInt(@NonNull String name) {
            if (this.propertyIndices.containsKey(name)) {
                throw new IllegalArgumentException("Property with name " + name + " already exists on builder!");
            }
            IntProperty property = new IntProperty(name, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.properties.add(property);
            this.propertyIndices.put(name, this.properties.size() - 1);
            return this;
        }

        public Builder addFloat(@NonNull String name, float min, float max) {
            if (this.propertyIndices.containsKey(name)) {
                throw new IllegalArgumentException("Property with name " + name + " already exists on builder!");
            }
            FloatProperty property = new FloatProperty(name, min, max);
            this.properties.add(property);
            this.propertyIndices.put(name, this.properties.size() - 1);
            return this;
        }

        public Builder addFloat(@NonNull String name) {
            if (this.propertyIndices.containsKey(name)) {
                throw new IllegalArgumentException("Property with name " + name + " already exists on builder!");
            }
            FloatProperty property = new FloatProperty(name, Float.MIN_NORMAL, Float.MAX_VALUE);
            this.properties.add(property);
            this.propertyIndices.put(name, this.properties.size() - 1);
            return this;
        }

        public Builder addBoolean(@NonNull String name) {
            if (this.propertyIndices.containsKey(name)) {
                throw new IllegalArgumentException("Property with name " + name + " already exists on builder!");
            }
            BooleanProperty property = new BooleanProperty(name);
            this.properties.add(property);
            this.propertyIndices.put(name, this.properties.size() - 1);
            return this;
        }

        public Builder addEnum(@NonNull String name, List<String> values) {
            if (this.propertyIndices.containsKey(name)) {
                throw new IllegalArgumentException("Property with name " + name + " already exists on builder!");
            }
            EnumProperty property = new EnumProperty(name, values);
            this.properties.add(property);
            this.propertyIndices.put(name, this.properties.size() - 1);
            return this;
        }

        public Builder addEnum(@NonNull String name, String ... values) {
            if (this.propertyIndices.containsKey(name)) {
                throw new IllegalArgumentException("Property with name " + name + " already exists on builder!");
            }
            List<String> valuesList = Arrays.asList(values);
            EnumProperty property = new EnumProperty(name, valuesList);
            this.properties.add(property);
            this.propertyIndices.put(name, this.properties.size() - 1);
            return this;
        }

        public GeyserEntityProperties build() {
            return new GeyserEntityProperties(this.properties, this.propertyIndices);
        }
    }
}

