/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.packet;

import java.util.List;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.FullContainerName;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class InventoryContentPacket
implements BedrockPacket {
    private List<ItemData> contents = new ObjectArrayList<ItemData>();
    private int containerId;
    private FullContainerName containerNameData = new FullContainerName(ContainerSlotType.ANVIL_INPUT, null);
    private int dynamicContainerSize;
    private ItemData storageItem = ItemData.AIR;

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.INVENTORY_CONTENT;
    }

    @Override
    public InventoryContentPacket clone() {
        try {
            return (InventoryContentPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public List<ItemData> getContents() {
        return this.contents;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public FullContainerName getContainerNameData() {
        return this.containerNameData;
    }

    @Deprecated
    public int getDynamicContainerSize() {
        return this.dynamicContainerSize;
    }

    public ItemData getStorageItem() {
        return this.storageItem;
    }

    public void setContents(List<ItemData> contents) {
        this.contents = contents;
    }

    public void setContainerId(int containerId) {
        this.containerId = containerId;
    }

    public void setContainerNameData(FullContainerName containerNameData) {
        this.containerNameData = containerNameData;
    }

    @Deprecated
    public void setDynamicContainerSize(int dynamicContainerSize) {
        this.dynamicContainerSize = dynamicContainerSize;
    }

    public void setStorageItem(ItemData storageItem) {
        this.storageItem = storageItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventoryContentPacket)) {
            return false;
        }
        InventoryContentPacket other = (InventoryContentPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.containerId != other.containerId) {
            return false;
        }
        if (this.dynamicContainerSize != other.dynamicContainerSize) {
            return false;
        }
        List<ItemData> this$contents = this.contents;
        List<ItemData> other$contents = other.contents;
        if (this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents)) {
            return false;
        }
        FullContainerName this$containerNameData = this.containerNameData;
        FullContainerName other$containerNameData = other.containerNameData;
        if (this$containerNameData == null ? other$containerNameData != null : !((Object)this$containerNameData).equals(other$containerNameData)) {
            return false;
        }
        ItemData this$storageItem = this.storageItem;
        ItemData other$storageItem = other.storageItem;
        return !(this$storageItem == null ? other$storageItem != null : !this$storageItem.equals(other$storageItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InventoryContentPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.containerId;
        result = result * 59 + this.dynamicContainerSize;
        List<ItemData> $contents = this.contents;
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        FullContainerName $containerNameData = this.containerNameData;
        result = result * 59 + ($containerNameData == null ? 43 : ((Object)$containerNameData).hashCode());
        ItemData $storageItem = this.storageItem;
        result = result * 59 + ($storageItem == null ? 43 : $storageItem.hashCode());
        return result;
    }

    public String toString() {
        return "InventoryContentPacket(contents=" + this.contents + ", containerId=" + this.containerId + ", containerNameData=" + this.containerNameData + ", dynamicContainerSize=" + this.dynamicContainerSize + ", storageItem=" + this.storageItem + ")";
    }
}

