/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.codec.v291.serializer;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.BedrockPacketSerializer;
import org.cloudburstmc.protocol.bedrock.data.MapDecoration;
import org.cloudburstmc.protocol.bedrock.data.MapTrackedObject;
import org.cloudburstmc.protocol.bedrock.packet.ClientboundMapItemDataPacket;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.longs.LongList;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.longs.LongListIterator;

public class ClientboundMapItemDataSerializer_v291
implements BedrockPacketSerializer<ClientboundMapItemDataPacket> {
    public static final ClientboundMapItemDataSerializer_v291 INSTANCE = new ClientboundMapItemDataSerializer_v291();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        LongList trackedEntityIds;
        VarInts.writeLong(buffer, packet.getUniqueMapId());
        int type = 0;
        int[] colors = packet.getColors();
        if (colors != null && colors.length > 0) {
            type |= 2;
        }
        List<MapDecoration> decorations = packet.getDecorations();
        List<MapTrackedObject> trackedObjects = packet.getTrackedObjects();
        if (!decorations.isEmpty() && !trackedObjects.isEmpty()) {
            type |= 4;
        }
        if (!(trackedEntityIds = packet.getTrackedEntityIds()).isEmpty()) {
            type |= 8;
        }
        VarInts.writeUnsignedInt(buffer, type);
        buffer.writeByte(packet.getDimensionId());
        if ((type & 8) != 0) {
            VarInts.writeUnsignedInt(buffer, trackedEntityIds.size());
            LongListIterator longListIterator = trackedEntityIds.iterator();
            while (longListIterator.hasNext()) {
                long trackedEntityId = (Long)longListIterator.next();
                VarInts.writeLong(buffer, trackedEntityId);
            }
        }
        if ((type & 0xE) != 0) {
            buffer.writeByte(packet.getScale());
        }
        if ((type & 4) != 0) {
            VarInts.writeUnsignedInt(buffer, trackedObjects.size());
            for (MapTrackedObject object : trackedObjects) {
                switch (object.getType()) {
                    case BLOCK: {
                        buffer.writeIntLE(object.getType().ordinal());
                        helper.writeBlockPosition(buffer, object.getPosition());
                        break;
                    }
                    case ENTITY: {
                        buffer.writeIntLE(object.getType().ordinal());
                        VarInts.writeLong(buffer, object.getEntityId());
                    }
                }
            }
            VarInts.writeUnsignedInt(buffer, decorations.size());
            for (MapDecoration decoration : decorations) {
                buffer.writeByte(decoration.getImage());
                buffer.writeByte(decoration.getRotation());
                buffer.writeByte(decoration.getXOffset());
                buffer.writeByte(decoration.getYOffset());
                helper.writeString(buffer, decoration.getLabel());
                VarInts.writeUnsignedInt(buffer, decoration.getColor());
            }
        }
        if ((type & 2) != 0) {
            VarInts.writeInt(buffer, packet.getWidth());
            VarInts.writeInt(buffer, packet.getHeight());
            VarInts.writeInt(buffer, packet.getXOffset());
            VarInts.writeInt(buffer, packet.getYOffset());
            VarInts.writeUnsignedInt(buffer, colors.length);
            for (Object color : (LongListIterator)colors) {
                VarInts.writeUnsignedInt(buffer, (int)color);
            }
        }
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        int i;
        int length;
        packet.setUniqueMapId(VarInts.readLong(buffer));
        int type = VarInts.readUnsignedInt(buffer);
        packet.setDimensionId(buffer.readUnsignedByte());
        if ((type & 8) != 0) {
            LongList trackedEntityIds = packet.getTrackedEntityIds();
            length = VarInts.readUnsignedInt(buffer);
            for (i = 0; i < length; ++i) {
                trackedEntityIds.add(VarInts.readLong(buffer));
            }
        }
        if ((type & 0xE) != 0) {
            packet.setScale(buffer.readUnsignedByte());
        }
        if ((type & 4) != 0) {
            List<MapTrackedObject> trackedObjects = packet.getTrackedObjects();
            length = VarInts.readUnsignedInt(buffer);
            block5: for (i = 0; i < length; ++i) {
                MapTrackedObject.Type objectType = MapTrackedObject.Type.values()[buffer.readIntLE()];
                switch (objectType) {
                    case BLOCK: {
                        trackedObjects.add(new MapTrackedObject(helper.readBlockPosition(buffer)));
                        continue block5;
                    }
                    case ENTITY: {
                        trackedObjects.add(new MapTrackedObject(VarInts.readLong(buffer)));
                    }
                }
            }
            List<MapDecoration> decorations = packet.getDecorations();
            length = VarInts.readUnsignedInt(buffer);
            for (int i2 = 0; i2 < length; ++i2) {
                short image = buffer.readUnsignedByte();
                short rotation = buffer.readUnsignedByte();
                short xOffset = buffer.readUnsignedByte();
                short yOffset = buffer.readUnsignedByte();
                String label = helper.readString(buffer);
                int color = VarInts.readUnsignedInt(buffer);
                decorations.add(new MapDecoration(image, rotation, xOffset, yOffset, label, color));
            }
        }
        if ((type & 2) != 0) {
            packet.setWidth(VarInts.readInt(buffer));
            packet.setHeight(VarInts.readInt(buffer));
            packet.setXOffset(VarInts.readInt(buffer));
            packet.setYOffset(VarInts.readInt(buffer));
            int length2 = VarInts.readUnsignedInt(buffer);
            int[] colors = new int[length2];
            for (i = 0; i < length2; ++i) {
                colors[i] = VarInts.readUnsignedInt(buffer);
            }
            packet.setColors(colors);
        }
    }

    protected ClientboundMapItemDataSerializer_v291() {
    }
}

