/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.imaginary;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.imaginary.Quaterniond;

@ParametersAreNonnullByDefault
public class ImmutableQuaterniond
extends Quaterniond {
    private static final long serialVersionUID = 1L;
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableQuaterniond(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getW() {
        return this.w;
    }

    @Override
    @Nonnull
    public Quaterniond add(double x, double y, double z, double w) {
        return Quaterniond.from(this.x + x, this.y + y, this.z + z, this.w + w);
    }

    @Override
    @Nonnull
    public Quaterniond sub(double x, double y, double z, double w) {
        return Quaterniond.from(this.x - x, this.y - y, this.z - z, this.w - w);
    }

    @Override
    @Nonnull
    public Quaterniond mul(double a) {
        return Quaterniond.from(this.x * a, this.y * a, this.z * a, this.w * a);
    }

    @Override
    @Nonnull
    public Quaterniond mul(double x, double y, double z, double w) {
        return Quaterniond.from(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y + this.y * w + this.z * x - this.x * z, this.w * z + this.z * w + this.x * y - this.y * x, this.w * w - this.x * x - this.y * y - this.z * z);
    }

    @Override
    @Nonnull
    public Quaterniond div(double a) {
        return Quaterniond.from(this.x / a, this.y / a, this.z / a, this.w / a);
    }

    @Override
    @Nonnull
    public Quaterniond div(double x, double y, double z, double w) {
        double d = x * x + y * y + z * z + w * w;
        return Quaterniond.from((this.x * w - this.w * x - this.z * y + this.y * z) / d, (this.y * w + this.z * x - this.w * y - this.x * z) / d, (this.z * w - this.y * x + this.x * y - this.w * z) / d, (this.w * w + this.x * x + this.y * y + this.z * z) / d);
    }

    @Override
    @Nonnull
    public Quaterniond conjugate() {
        return Quaterniond.from(-this.x, -this.y, -this.z, this.w);
    }

    @Override
    @Nonnull
    public Quaterniond invert() {
        double lengthSquared = this.lengthSquared();
        if (Math.abs(lengthSquared) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot invert a quaternion of length zero");
        }
        return this.conjugate().div(lengthSquared);
    }

    @Override
    @Nonnull
    public Quaterniond normalize() {
        double length = this.length();
        if (Math.abs(length) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero quaternion");
        }
        return Quaterniond.from(this.x / length, this.y / length, this.z / length, this.w / length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quaterniond)) {
            return false;
        }
        Quaterniond quaternion = (Quaterniond)o;
        if (Double.compare(quaternion.getW(), this.w) != 0) {
            return false;
        }
        if (Double.compare(quaternion.getX(), this.x) != 0) {
            return false;
        }
        if (Double.compare(quaternion.getY(), this.y) != 0) {
            return false;
        }
        return Double.compare(quaternion.getZ(), this.z) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0 ? Double.hashCode(this.x) : 0;
            result = 31 * result + (this.y != 0.0 ? Double.hashCode(this.y) : 0);
            result = 31 * result + (this.z != 0.0 ? Double.hashCode(this.z) : 0);
            this.hashCode = 31 * result + (this.w != 0.0 ? Double.hashCode(this.w) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

