/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.util.StatisticFormatters;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.BreakBlockStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.BreakItemStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.CraftItemStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.CustomStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.DropItemStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.KillEntityStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.KilledByEntityStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.PickupItemStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.Statistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.UseItemStatistic;

public class StatisticsUtils {
    private static final Pattern CONTENT_PATTERN = Pattern.compile("^\\S+:", 8);

    public static void buildAndSendStatisticsMenu(GeyserSession session) {
        String language = session.locale();
        session.sendForm((FormBuilder<?, ?, ?>)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().translator(StatisticsUtils::translate, language)).title("gui.stats")).button("stat.generalButton", FormImage.Type.PATH, "textures/ui/World").button("stat.itemsButton - stat_type.minecraft.mined", FormImage.Type.PATH, "textures/items/iron_pickaxe").button("stat.itemsButton - stat_type.minecraft.broken", FormImage.Type.PATH, "textures/items/record_11").button("stat.itemsButton - stat_type.minecraft.crafted", FormImage.Type.PATH, "textures/blocks/crafting_table_side").button("stat.itemsButton - stat_type.minecraft.used", FormImage.Type.PATH, "textures/ui/Wrenches1").button("stat.itemsButton - stat_type.minecraft.picked_up", FormImage.Type.PATH, "textures/blocks/chest_front").button("stat.itemsButton - stat_type.minecraft.dropped", FormImage.Type.PATH, "textures/ui/trash_default").button("stat.mobsButton - geyser.statistics.killed", FormImage.Type.PATH, "textures/items/diamond_sword").button("stat.mobsButton - geyser.statistics.killed_by", FormImage.Type.PATH, "textures/ui/wither_heart_flash").validResultHandler(response -> {
            SimpleForm.Builder builder = (SimpleForm.Builder)SimpleForm.builder().translator(StatisticsUtils::translate, language);
            ArrayList<CallSite> content = new ArrayList<CallSite>();
            List itemRegistry = (List)Registries.JAVA_ITEMS.get();
            switch (response.clickedButtonId()) {
                case 0: {
                    Statistic statistic;
                    builder.title("stat.generalButton");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt4551$temp = entry.getKey();
                        if (!(patt4551$temp instanceof CustomStatistic)) continue;
                        statistic = (CustomStatistic)patt4551$temp;
                        String statName = ((Enum)((Object)statistic)).name().toLowerCase(Locale.ROOT);
                        IntFunction<String> formatter = StatisticFormatters.get(((CustomStatistic)statistic).getFormat());
                        content.add((CallSite)((Object)("stat.minecraft." + statName + ": " + formatter.apply(entry.getIntValue()))));
                    }
                    break;
                }
                case 1: {
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.mined");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Block block;
                        Object patt5403$temp = entry.getKey();
                        if (!(patt5403$temp instanceof BreakBlockStatistic) || (block = BlockRegistries.JAVA_BLOCKS.get(((BreakBlockStatistic)(statistic = (BreakBlockStatistic)patt5403$temp)).getId())) == null) continue;
                        String identifier = "block.minecraft." + block.javaIdentifier().value();
                        content.add((CallSite)((Object)(identifier + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 2: {
                    Item item;
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.broken");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt6342$temp = entry.getKey();
                        if (!(patt6342$temp instanceof BreakItemStatistic)) continue;
                        statistic = (BreakItemStatistic)patt6342$temp;
                        item = (Item)itemRegistry.get(((BreakItemStatistic)statistic).getId());
                        content.add((CallSite)((Object)(StatisticsUtils.getItemTranslateKey(item, language) + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 3: {
                    Item item;
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.crafted");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt7053$temp = entry.getKey();
                        if (!(patt7053$temp instanceof CraftItemStatistic)) continue;
                        statistic = (CraftItemStatistic)patt7053$temp;
                        item = (Item)itemRegistry.get(((CraftItemStatistic)statistic).getId());
                        content.add((CallSite)((Object)(StatisticsUtils.getItemTranslateKey(item, language) + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 4: {
                    Item item;
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.used");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt7761$temp = entry.getKey();
                        if (!(patt7761$temp instanceof UseItemStatistic)) continue;
                        statistic = (UseItemStatistic)patt7761$temp;
                        item = (Item)itemRegistry.get(((UseItemStatistic)statistic).getId());
                        content.add((CallSite)((Object)(StatisticsUtils.getItemTranslateKey(item, language) + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 5: {
                    Item item;
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.picked_up");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt8472$temp = entry.getKey();
                        if (!(patt8472$temp instanceof PickupItemStatistic)) continue;
                        statistic = (PickupItemStatistic)patt8472$temp;
                        item = (Item)itemRegistry.get(((PickupItemStatistic)statistic).getId());
                        content.add((CallSite)((Object)(StatisticsUtils.getItemTranslateKey(item, language) + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 6: {
                    Item item;
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.dropped");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt9184$temp = entry.getKey();
                        if (!(patt9184$temp instanceof DropItemStatistic)) continue;
                        statistic = (DropItemStatistic)patt9184$temp;
                        item = (Item)itemRegistry.get(((DropItemStatistic)statistic).getId());
                        content.add((CallSite)((Object)(StatisticsUtils.getItemTranslateKey(item, language) + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 7: {
                    String entityName;
                    Statistic statistic;
                    builder.title("stat.mobsButton - geyser.statistics.killed");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt9890$temp = entry.getKey();
                        if (!(patt9890$temp instanceof KillEntityStatistic)) continue;
                        statistic = (KillEntityStatistic)patt9890$temp;
                        entityName = ((KillEntityStatistic)statistic).getEntity().name().toLowerCase(Locale.ROOT);
                        content.add((CallSite)((Object)("entity.minecraft." + entityName + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 8: {
                    String entityName;
                    Statistic statistic;
                    builder.title("stat.mobsButton - geyser.statistics.killed_by");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt10624$temp = entry.getKey();
                        if (!(patt10624$temp instanceof KilledByEntityStatistic)) continue;
                        statistic = (KilledByEntityStatistic)patt10624$temp;
                        entityName = ((KilledByEntityStatistic)statistic).getEntity().name().toLowerCase(Locale.ROOT);
                        content.add((CallSite)((Object)("entity.minecraft." + entityName + ": " + entry.getIntValue())));
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            StringBuilder assembledContent = new StringBuilder();
            if (content.size() == 0) {
                assembledContent.append("geyser.statistics.none");
            } else {
                void var7_18;
                content.replaceAll(x -> StatisticsUtils.translate(x, language));
                content.sort(String::compareTo);
                boolean bl = false;
                while (var7_18 < content.size()) {
                    assembledContent.append((String)content.get((int)var7_18));
                    if (var7_18 % 2 == false) {
                        assembledContent.append("\u00a77\n");
                    } else {
                        assembledContent.append("\u00a7r\n");
                    }
                    ++var7_18;
                }
            }
            session.sendForm((FormBuilder<?, ?, ?>)builder.content(assembledContent.toString()).button("gui.back", FormImage.Type.PATH, "textures/gui/newgui/undo").validResultHandler(response1 -> StatisticsUtils.buildAndSendStatisticsMenu(session)));
        }));
    }

    private static String getItemTranslateKey(Item item, String language) {
        return MinecraftLocale.getLocaleString(item.translationKey(), language);
    }

    private static String translate(String keys, String locale) {
        Matcher matcher = CONTENT_PATTERN.matcher(keys);
        StringBuilder buffer = new StringBuilder();
        while (matcher.find()) {
            String group = matcher.group();
            matcher.appendReplacement(buffer, StatisticsUtils.translateEntry(group.substring(0, group.length() - 1), locale) + ":");
        }
        if (buffer.length() != 0) {
            return matcher.appendTail(buffer).toString();
        }
        CharSequence[] keySplitted = keys.split(" - ");
        for (int i = 0; i < keySplitted.length; ++i) {
            keySplitted[i] = StatisticsUtils.translateEntry((String)keySplitted[i], locale);
        }
        return String.join((CharSequence)" - ", keySplitted);
    }

    private static String translateEntry(String key, String locale) {
        if (key.startsWith("geyser.")) {
            return GeyserLocale.getPlayerLocaleString(key, locale);
        }
        return MinecraftLocale.getLocaleString(key, locale);
    }
}

