/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.databind.jsontype.impl;

import java.io.IOException;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.core.JsonToken;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.core.type.WritableTypeId;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;

public abstract class TypeSerializerBase
extends TypeSerializer {
    protected final TypeIdResolver _idResolver;
    protected final BeanProperty _property;

    protected TypeSerializerBase(TypeIdResolver idRes, BeanProperty property) {
        this._idResolver = idRes;
        this._property = property;
    }

    @Override
    public abstract JsonTypeInfo.As getTypeInclusion();

    @Override
    public String getPropertyName() {
        return null;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    @Override
    public WritableTypeId writeTypePrefix(JsonGenerator g, WritableTypeId idMetadata) throws IOException {
        this._generateTypeId(idMetadata);
        if (idMetadata.id == null) {
            return this._writeTypePrefixForNull(g, idMetadata);
        }
        return g.writeTypePrefix(idMetadata);
    }

    @Override
    public WritableTypeId writeTypeSuffix(JsonGenerator g, WritableTypeId idMetadata) throws IOException {
        if (idMetadata == null) {
            return this._writeTypeSuffixfixForNull(g, idMetadata);
        }
        return g.writeTypeSuffix(idMetadata);
    }

    private WritableTypeId _writeTypePrefixForNull(JsonGenerator g, WritableTypeId typeIdDef) throws IOException {
        JsonToken valueShape = typeIdDef.valueShape;
        typeIdDef.wrapperWritten = false;
        if (valueShape == JsonToken.START_OBJECT) {
            g.writeStartObject(typeIdDef.forValue);
        } else if (valueShape == JsonToken.START_ARRAY) {
            g.writeStartArray(typeIdDef.forValue);
        }
        return typeIdDef;
    }

    private WritableTypeId _writeTypeSuffixfixForNull(JsonGenerator g, WritableTypeId typeIdDef) throws IOException {
        JsonToken valueShape = typeIdDef.valueShape;
        if (valueShape == JsonToken.START_OBJECT) {
            g.writeEndObject();
        } else if (valueShape == JsonToken.START_ARRAY) {
            g.writeEndArray();
        }
        return typeIdDef;
    }

    protected void _generateTypeId(WritableTypeId idMetadata) {
        Object id = idMetadata.id;
        if (id == null) {
            Object value = idMetadata.forValue;
            Class<?> typeForId = idMetadata.forValueType;
            id = typeForId == null ? this.idFromValue(value) : this.idFromValueAndType(value, typeForId);
            idMetadata.id = id;
        }
    }

    protected String idFromValue(Object value) {
        String id = this._idResolver.idFromValue(value);
        if (id == null) {
            this.handleMissingId(value);
        }
        return id;
    }

    protected String idFromValueAndType(Object value, Class<?> type) {
        String id = this._idResolver.idFromValueAndType(value, type);
        if (id == null) {
            this.handleMissingId(value);
        }
        return id;
    }

    protected void handleMissingId(Object value) {
    }
}

