/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.netty.channel.raknet.RakDisconnectReason;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.protocol.bedrock.BedrockDisconnectReasons;
import org.cloudburstmc.protocol.bedrock.BedrockSession;
import org.cloudburstmc.protocol.bedrock.BedrockSessionFactory;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.v428.Bedrock_v428;
import org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.CompressionCodec;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.CompressionStrategy;
import org.cloudburstmc.protocol.bedrock.netty.codec.encryption.BedrockEncryptionDecoder;
import org.cloudburstmc.protocol.bedrock.netty.codec.encryption.BedrockEncryptionEncoder;
import org.cloudburstmc.protocol.bedrock.netty.codec.packet.BedrockPacketCodec;
import org.cloudburstmc.protocol.bedrock.netty.initializer.BedrockChannelInitializer;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.util.EncryptionUtils;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class BedrockPeer
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "bedrock-peer";
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BedrockPeer.class);
    protected final Int2ObjectMap<BedrockSession> sessions = new Int2ObjectOpenHashMap<BedrockSession>();
    protected final Queue<BedrockPacketWrapper> packetQueue = PlatformDependent.newMpscQueue();
    protected final Channel channel;
    protected final BedrockSessionFactory sessionFactory;
    protected ScheduledFuture<?> tickFuture;
    protected AtomicBoolean closed = new AtomicBoolean();

    public BedrockPeer(Channel channel, BedrockSessionFactory sessionFactory) {
        this.channel = channel;
        this.sessionFactory = sessionFactory;
    }

    protected void onBedrockPacket(BedrockPacketWrapper wrapper) {
        int targetId = wrapper.getTargetSubClientId();
        BedrockSession session = this.sessions.computeIfAbsent(targetId, this::onSessionCreated);
        session.onPacket(wrapper);
    }

    protected BedrockSession onSessionCreated(int sessionId) {
        return this.sessionFactory.createSession(this, sessionId);
    }

    protected void checkForClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Peer has been closed");
        }
    }

    protected void removeSession(BedrockSession session) {
        this.sessions.remove(session.subClientId, (Object)session);
    }

    protected void onTick() {
        if (this.closed.get()) {
            return;
        }
        if (!this.packetQueue.isEmpty()) {
            BedrockPacketWrapper packet;
            while ((packet = this.packetQueue.poll()) != null) {
                this.channel.write((Object)packet);
            }
            this.channel.flush();
        }
    }

    private void onRakNetDisconnect(ChannelHandlerContext ctx, RakDisconnectReason reason) {
        String disconnectReason = BedrockDisconnectReasons.getReason(reason);
        for (BedrockSession session : this.sessions.values()) {
            session.disconnectReason = disconnectReason;
        }
    }

    private void free() {
        for (BedrockPacketWrapper wrapper : this.packetQueue) {
            ReferenceCountUtil.safeRelease((Object)((Object)wrapper));
        }
    }

    public void sendPacket(int senderClientId, int targetClientId, BedrockPacket packet) {
        this.packetQueue.add(BedrockPacketWrapper.create(0, senderClientId, targetClientId, packet, null));
    }

    public void sendPacketImmediately(int senderClientId, int targetClientId, BedrockPacket packet) {
        this.channel.writeAndFlush((Object)BedrockPacketWrapper.create(0, senderClientId, targetClientId, packet, null));
    }

    public void enableEncryption(@NonNull SecretKey secretKey) {
        Objects.requireNonNull(secretKey, "secretKey");
        if (!secretKey.getAlgorithm().equals("AES")) {
            throw new IllegalArgumentException("Invalid key algorithm");
        }
        if (this.channel.pipeline().get(BedrockEncryptionEncoder.class) != null || this.channel.pipeline().get(BedrockEncryptionDecoder.class) != null) {
            throw new IllegalStateException("Encryption is already enabled");
        }
        int protocolVersion = this.getCodec().getProtocolVersion();
        boolean useCtr = protocolVersion >= Bedrock_v428.CODEC.getProtocolVersion();
        this.channel.pipeline().addAfter("frame-id-codec", "bedrock-encryption-encoder", (ChannelHandler)new BedrockEncryptionEncoder(secretKey, EncryptionUtils.createCipher(useCtr, true, secretKey)));
        this.channel.pipeline().addAfter("frame-id-codec", "bedrock-encryption-decoder", (ChannelHandler)new BedrockEncryptionDecoder(secretKey, EncryptionUtils.createCipher(useCtr, false, secretKey)));
        log.debug("Encryption enabled for {}", (Object)this.getSocketAddress());
    }

    public void setCompression(PacketCompressionAlgorithm algorithm) {
        Objects.requireNonNull(algorithm, "algorithm");
        this.setCompression(BedrockChannelInitializer.getCompression(algorithm, this.getRakVersion(), false));
    }

    public void setCompression(CompressionStrategy strategy) {
        Objects.requireNonNull(strategy, "strategy");
        boolean needsPrefix = this.getCodec().getProtocolVersion() >= 649;
        ChannelHandler handler = this.channel.pipeline().get("compression-codec");
        if (handler == null) {
            this.channel.pipeline().addBefore("bedrock-batch-decoder", "compression-codec", (ChannelHandler)new CompressionCodec(strategy, needsPrefix));
        } else {
            this.channel.pipeline().replace("compression-codec", "compression-codec", (ChannelHandler)new CompressionCodec(strategy, needsPrefix));
        }
    }

    public CompressionStrategy getCompressionStrategy() {
        ChannelHandler handler = this.channel.pipeline().get("compression-codec");
        if (!(handler instanceof CompressionCodec)) {
            return null;
        }
        return ((CompressionCodec)handler).getStrategy();
    }

    public BedrockCodec getCodec() {
        return ((BedrockPacketCodec)this.channel.pipeline().get(BedrockPacketCodec.class)).getCodec();
    }

    public BedrockCodecHelper getCodecHelper() {
        return ((BedrockPacketCodec)this.channel.pipeline().get(BedrockPacketCodec.class)).getHelper();
    }

    public void setCodec(BedrockCodec codec) {
        Objects.requireNonNull(codec, "codec");
        ((BedrockPacketCodec)this.channel.pipeline().get(BedrockPacketCodec.class)).setCodec(codec);
    }

    public void close(String reason) {
        for (BedrockSession session : this.sessions.values()) {
            session.disconnectReason = reason;
        }
        this.channel.disconnect();
    }

    protected void onClose() {
        if (this.channel.isOpen()) {
            log.warn("Tried to close peer, but channel is open!", new Throwable());
            return;
        }
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.tickFuture != null) {
            this.tickFuture.cancel(false);
            this.tickFuture = null;
        }
        for (BedrockSession session : this.sessions.values()) {
            try {
                session.onClose();
            }
            catch (Exception e) {
                log.error("Exception whilst closing session", (Throwable)e);
            }
        }
        this.free();
    }

    public boolean isConnected() {
        return !this.closed.get() && this.channel.isOpen();
    }

    public boolean isConnecting() {
        return !this.channel.isActive() && !this.closed.get();
    }

    public SocketAddress getSocketAddress() {
        return this.channel.remoteAddress();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getRakVersion() {
        return (Integer)this.channel.config().getOption(RakChannelOption.RAK_PROTOCOL_VERSION);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.onClose();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.sessions.put(0, this.sessionFactory.createSession(this, 0));
        this.tickFuture = this.channel.eventLoop().scheduleAtFixedRate(this::onTick, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.onClose();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block4: {
            try {
                if (msg instanceof BedrockPacketWrapper) {
                    this.onBedrockPacket((BedrockPacketWrapper)((Object)msg));
                    break block4;
                }
                throw new DecoderException("Unexpected message type: " + msg.getClass().getName());
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof RakDisconnectReason) {
            this.onRakNetDisconnect(ctx, (RakDisconnectReason)((Object)evt));
        }
    }
}

