/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundCooldownPacket
implements MinecraftPacket {
    private final Key cooldownGroup;
    private final int cooldownTicks;

    public ClientboundCooldownPacket(ByteBuf in) {
        this.cooldownGroup = MinecraftTypes.readResourceLocation(in);
        this.cooldownTicks = MinecraftTypes.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeResourceLocation(out, this.cooldownGroup);
        MinecraftTypes.writeVarInt(out, this.cooldownTicks);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Key getCooldownGroup() {
        return this.cooldownGroup;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCooldownPacket)) {
            return false;
        }
        ClientboundCooldownPacket other = (ClientboundCooldownPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCooldownTicks() != other.getCooldownTicks()) {
            return false;
        }
        Key this$cooldownGroup = this.getCooldownGroup();
        Key other$cooldownGroup = other.getCooldownGroup();
        return !(this$cooldownGroup == null ? other$cooldownGroup != null : !this$cooldownGroup.equals(other$cooldownGroup));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundCooldownPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCooldownTicks();
        Key $cooldownGroup = this.getCooldownGroup();
        result = result * 59 + ($cooldownGroup == null ? 43 : $cooldownGroup.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundCooldownPacket(cooldownGroup=" + String.valueOf(this.getCooldownGroup()) + ", cooldownTicks=" + this.getCooldownTicks() + ")";
    }

    public @NonNull ClientboundCooldownPacket withCooldownGroup(Key cooldownGroup) {
        return this.cooldownGroup == cooldownGroup ? this : new ClientboundCooldownPacket(cooldownGroup, this.cooldownTicks);
    }

    public @NonNull ClientboundCooldownPacket withCooldownTicks(int cooldownTicks) {
        return this.cooldownTicks == cooldownTicks ? this : new ClientboundCooldownPacket(this.cooldownGroup, cooldownTicks);
    }

    public ClientboundCooldownPacket(Key cooldownGroup, int cooldownTicks) {
        this.cooldownGroup = cooldownGroup;
        this.cooldownTicks = cooldownTicks;
    }
}

