/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.chunk;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.DataPalette;

public class ChunkSection {
    private static final int AIR = 0;
    private int blockCount;
    @lombok.NonNull
    private DataPalette chunkData;
    @lombok.NonNull
    private DataPalette biomeData;

    public ChunkSection() {
        this(0, DataPalette.createForChunk(), DataPalette.createForBiome());
    }

    public ChunkSection(ChunkSection original) {
        this(original.blockCount, new DataPalette(original.chunkData), new DataPalette(original.biomeData));
    }

    public int getBlock(int x, int y, int z) {
        return this.chunkData.get(x, y, z);
    }

    public void setBlock(int x, int y, int z, int state) {
        int curr = this.chunkData.set(x, y, z, state);
        if (state != 0 && curr == 0) {
            ++this.blockCount;
        } else if (state == 0 && curr != 0) {
            --this.blockCount;
        }
    }

    public boolean isBlockCountEmpty() {
        return this.blockCount == 0;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    @lombok.NonNull
    public DataPalette getChunkData() {
        return this.chunkData;
    }

    public @NonNull String toString() {
        return "ChunkSection(blockCount=" + this.getBlockCount() + ", chunkData=" + String.valueOf(this.getChunkData()) + ", biomeData=" + String.valueOf(this.getBiomeData()) + ")";
    }

    public ChunkSection(int blockCount, @lombok.NonNull DataPalette chunkData, @lombok.NonNull DataPalette biomeData) {
        if (chunkData == null) {
            throw new NullPointerException("chunkData is marked non-null but is null");
        }
        if (biomeData == null) {
            throw new NullPointerException("biomeData is marked non-null but is null");
        }
        this.blockCount = blockCount;
        this.chunkData = chunkData;
        this.biomeData = biomeData;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunkSection)) {
            return false;
        }
        ChunkSection other = (ChunkSection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBlockCount() != other.getBlockCount()) {
            return false;
        }
        DataPalette this$chunkData = this.getChunkData();
        DataPalette other$chunkData = other.getChunkData();
        if (this$chunkData == null ? other$chunkData != null : !((Object)this$chunkData).equals(other$chunkData)) {
            return false;
        }
        DataPalette this$biomeData = this.getBiomeData();
        DataPalette other$biomeData = other.getBiomeData();
        return !(this$biomeData == null ? other$biomeData != null : !((Object)this$biomeData).equals(other$biomeData));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChunkSection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBlockCount();
        DataPalette $chunkData = this.getChunkData();
        result = result * 59 + ($chunkData == null ? 43 : ((Object)$chunkData).hashCode());
        DataPalette $biomeData = this.getBiomeData();
        result = result * 59 + ($biomeData == null ? 43 : ((Object)$biomeData).hashCode());
        return result;
    }

    @lombok.NonNull
    public DataPalette getBiomeData() {
        return this.biomeData;
    }
}

