/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.packet;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.geysermc.mcprotocollib.network.codec.PacketDefinition;
import org.geysermc.mcprotocollib.network.codec.PacketSerializer;
import org.geysermc.mcprotocollib.network.packet.Packet;

public class PacketRegistry {
    private final Int2ObjectMap<PacketDefinition<? extends Packet>> serverbound = new Int2ObjectOpenHashMap<PacketDefinition<? extends Packet>>();
    private final Int2ObjectMap<PacketDefinition<? extends Packet>> clientbound = new Int2ObjectOpenHashMap<PacketDefinition<? extends Packet>>();
    private final Map<Class<? extends Packet>, Integer> clientboundIds = new IdentityHashMap<Class<? extends Packet>, Integer>();
    private final Map<Class<? extends Packet>, Integer> serverboundIds = new IdentityHashMap<Class<? extends Packet>, Integer>();

    public final void clearPackets() {
        this.serverbound.clear();
        this.clientbound.clear();
        this.clientboundIds.clear();
        this.serverboundIds.clear();
    }

    public final <T extends Packet> void register(int id, Class<T> packet, PacketSerializer<T> serializer) {
        this.registerServerbound(id, packet, serializer);
        this.registerClientbound(id, packet, serializer);
    }

    public final void register(PacketDefinition<? extends Packet> definition) {
        this.registerServerbound(definition);
        this.registerClientbound(definition);
    }

    public final <T extends Packet> void registerServerbound(int id, Class<T> packet, PacketSerializer<T> serializer) {
        this.registerServerbound(new PacketDefinition<T>(id, packet, serializer));
    }

    public final void registerServerbound(PacketDefinition<? extends Packet> definition) {
        this.serverbound.put(definition.getId(), definition);
        this.serverboundIds.put(definition.getPacketClass(), definition.getId());
    }

    public final <T extends Packet> void registerClientbound(int id, Class<T> packet, PacketSerializer<T> serializer) {
        this.registerClientbound(new PacketDefinition<T>(id, packet, serializer));
    }

    public final void registerClientbound(PacketDefinition<? extends Packet> definition) {
        this.clientbound.put(definition.getId(), definition);
        this.clientboundIds.put(definition.getPacketClass(), definition.getId());
    }

    public Packet createClientboundPacket(int id, ByteBuf buf) {
        PacketDefinition definition = (PacketDefinition)this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.newInstance(buf);
    }

    public int getClientboundId(Class<? extends Packet> packetClass) {
        Integer packetId = this.clientboundIds.get(packetClass);
        if (packetId == null) {
            throw new IllegalArgumentException("Unregistered clientbound packet class: " + packetClass.getName());
        }
        return packetId;
    }

    public int getClientboundId(Packet packet) {
        return this.getClientboundId(packet.getClass());
    }

    public Class<? extends Packet> getClientboundClass(int id) {
        PacketDefinition definition = (PacketDefinition)this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.getPacketClass();
    }

    public Packet createServerboundPacket(int id, ByteBuf buf) {
        PacketDefinition definition = (PacketDefinition)this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.newInstance(buf);
    }

    public int getServerboundId(Class<? extends Packet> packetClass) {
        Integer packetId = this.serverboundIds.get(packetClass);
        if (packetId == null) {
            throw new IllegalArgumentException("Unregistered serverbound packet class: " + packetClass.getName());
        }
        return packetId;
    }

    public int getServerboundId(Packet packet) {
        return this.getServerboundId(packet.getClass());
    }

    public Class<? extends Packet> getServerboundClass(int id) {
        PacketDefinition definition = (PacketDefinition)this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.getPacketClass();
    }

    public PacketDefinition<?> getServerboundDefinition(int id) {
        PacketDefinition definition = (PacketDefinition)this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition;
    }

    public PacketDefinition<?> getClientboundDefinition(int id) {
        PacketDefinition definition = (PacketDefinition)this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition;
    }
}

