/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.skin.Cape;
import org.geysermc.geyser.api.skin.Skin;
import org.geysermc.geyser.api.skin.SkinData;
import org.geysermc.geyser.api.skin.SkinGeometry;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.mcprotocollib.auth.GameProfile;

public class FakeHeadProvider {
    private static final LoadingCache<FakeHeadEntry, SkinData> MERGED_SKINS_LOADING_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(10000L).build(new CacheLoader<FakeHeadEntry, SkinData>(){

        @Override
        public SkinData load(@NonNull FakeHeadEntry fakeHeadEntry) throws Exception {
            SkinData skinData = SkinProvider.getOrDefault(SkinProvider.requestSkinData(fakeHeadEntry.getEntity(), fakeHeadEntry.getSession()), null, 5);
            if (skinData == null) {
                throw new Exception("Couldn't load player's original skin");
            }
            Skin skin = skinData.skin();
            Cape cape = skinData.cape();
            SkinGeometry geometry = skinData.geometry().geometryName().equals("{\"geometry\" :{\"default\" :\"geometry.humanoid.customSlim\"}}") ? SkinProvider.WEARING_CUSTOM_SKULL_SLIM : SkinProvider.WEARING_CUSTOM_SKULL;
            Skin headSkin = SkinProvider.getOrDefault(SkinProvider.requestSkin(fakeHeadEntry.getEntity().getUuid(), fakeHeadEntry.getFakeHeadSkinUrl(), false), SkinProvider.EMPTY_SKIN, 5);
            BufferedImage originalSkinImage = SkinProvider.imageDataToBufferedImage(skin.skinData(), 64, skin.skinData().length / 4 / 64);
            BufferedImage headSkinImage = SkinProvider.imageDataToBufferedImage(headSkin.skinData(), 64, headSkin.skinData().length / 4 / 64);
            Graphics2D graphics2D = originalSkinImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, 64, 16);
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.drawImage(headSkinImage, 0, 0, 64, 16, 0, 0, 64, 16, null);
            graphics2D.dispose();
            String skinKey = "customPlayerHead_" + fakeHeadEntry.getFakeHeadSkinUrl() + "_" + skin.textureUrl();
            byte[] targetSkinData = SkinProvider.bufferedImageToImageData(originalSkinImage);
            Skin mergedSkin = new Skin(skinKey, targetSkinData);
            fakeHeadEntry.setEntity(null);
            fakeHeadEntry.setSession(null);
            return new SkinData(mergedSkin, cape, geometry);
        }
    });

    public static void setHead(GeyserSession session, PlayerEntity entity, @Nullable GameProfile profile) {
        Map<GameProfile.TextureType, GameProfile.Texture> textures;
        if (profile == null) {
            return;
        }
        GameProfile current = session.getPlayerWithCustomHeads().get(entity.getUuid());
        if (profile.equals(current)) {
            return;
        }
        try {
            textures = profile.getTextures(false);
        }
        catch (IllegalStateException e) {
            GeyserImpl.getInstance().getLogger().debug("Could not decode player head from profile %s, got: %s".formatted(profile, e.getMessage()));
            textures = null;
        }
        if (textures == null || textures.isEmpty()) {
            FakeHeadProvider.loadHeadFromProfile(session, entity, profile);
            return;
        }
        GameProfile.Texture skinTexture = textures.get((Object)GameProfile.TextureType.SKIN);
        if (skinTexture == null) {
            return;
        }
        GameProfile.Texture capeTexture = textures.get((Object)GameProfile.TextureType.CAPE);
        String capeUrl = capeTexture != null ? capeTexture.getURL() : null;
        boolean isAlex = skinTexture.getModel() == GameProfile.TextureModel.SLIM;
        FakeHeadProvider.loadHeadFromProfile(session, entity, new SkinManager.GameProfileData(skinTexture.getURL(), capeUrl, isAlex), profile);
    }

    public static void loadHeadFromProfile(GeyserSession session, PlayerEntity entity, GameProfile profile) {
        CompletableFuture<String> texturesFuture = profile.getId() != null ? SkinProvider.requestTexturesFromUUID(profile.getId().toString()) : SkinProvider.requestTexturesFromUsername(profile.getName());
        texturesFuture.whenCompleteAsync((encodedJson, throwable) -> {
            if (throwable != null) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid()), (Throwable)throwable);
                return;
            }
            try {
                SkinManager.GameProfileData gameProfileData = SkinManager.GameProfileData.loadFromJson(encodedJson);
                if (gameProfileData == null) {
                    return;
                }
                FakeHeadProvider.loadHeadFromProfile(session, entity, gameProfileData, profile);
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid(), e.getMessage()));
            }
        });
    }

    public static void loadHeadFromProfile(GeyserSession session, PlayerEntity entity, SkinManager.GameProfileData gameProfileData, GameProfile profile) {
        String fakeHeadSkinUrl = gameProfileData.skinUrl();
        session.getPlayerWithCustomHeads().put(entity.getUuid(), profile);
        String texturesProperty = entity.getTexturesProperty();
        SkinProvider.getExecutorService().execute(() -> {
            try {
                SkinData mergedSkinData = MERGED_SKINS_LOADING_CACHE.get(new FakeHeadEntry(texturesProperty, fakeHeadSkinUrl, entity, session));
                SkinManager.sendSkinPacket(session, entity, mergedSkinData);
            }
            catch (ExecutionException e) {
                GeyserImpl.getInstance().getLogger().error("Couldn't merge skin of " + entity.getUsername() + " with head skin url " + fakeHeadSkinUrl, e);
            }
        });
    }

    public static void restoreOriginalSkin(GeyserSession session, LivingEntity livingEntity) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity entity = (PlayerEntity)livingEntity;
        if (session.getPlayerWithCustomHeads().remove(entity.getUuid()) == null) {
            return;
        }
        SkinProvider.requestSkinData(entity, session).whenCompleteAsync((skinData, throwable) -> {
            if (throwable != null) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid()), (Throwable)throwable);
                return;
            }
            SkinManager.sendSkinPacket(session, entity, skinData);
        });
    }

    private static class FakeHeadEntry {
        private final String texturesProperty;
        private final String fakeHeadSkinUrl;
        private PlayerEntity entity;
        private GeyserSession session;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FakeHeadEntry that = (FakeHeadEntry)o;
            return Objects.equals(this.texturesProperty, that.texturesProperty) && Objects.equals(this.fakeHeadSkinUrl, that.fakeHeadSkinUrl);
        }

        public int hashCode() {
            return Objects.hash(this.texturesProperty, this.fakeHeadSkinUrl);
        }

        public FakeHeadEntry(String texturesProperty, String fakeHeadSkinUrl, PlayerEntity entity, GeyserSession session) {
            this.texturesProperty = texturesProperty;
            this.fakeHeadSkinUrl = fakeHeadSkinUrl;
            this.entity = entity;
            this.session = session;
        }

        public String getTexturesProperty() {
            return this.texturesProperty;
        }

        public String getFakeHeadSkinUrl() {
            return this.fakeHeadSkinUrl;
        }

        public PlayerEntity getEntity() {
            return this.entity;
        }

        public GeyserSession getSession() {
            return this.session;
        }

        public void setEntity(PlayerEntity entity) {
            this.entity = entity;
        }

        public void setSession(GeyserSession session) {
            this.session = session;
        }
    }
}

