/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.living.animal.FrogEntity;
import org.geysermc.geyser.entity.type.living.animal.VariantHolder;
import org.geysermc.geyser.entity.type.living.animal.farm.TemperatureVariantAnimal;
import org.geysermc.geyser.entity.type.living.animal.tameable.CatEntity;
import org.geysermc.geyser.entity.type.living.animal.tameable.WolfEntity;
import org.geysermc.geyser.inventory.item.BannerPattern;
import org.geysermc.geyser.inventory.item.GeyserInstrument;
import org.geysermc.geyser.inventory.recipe.TrimRecipe;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.level.JukeboxSong;
import org.geysermc.geyser.level.PaintingType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistry;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.session.cache.registry.RegistryEntryData;
import org.geysermc.geyser.session.cache.registry.RegistryUnit;
import org.geysermc.geyser.session.cache.registry.SimpleJavaRegistry;
import org.geysermc.geyser.text.ChatDecoration;
import org.geysermc.geyser.translator.level.BiomeTranslator;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;
import org.geysermc.mcprotocollib.protocol.data.game.RegistryEntry;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundRegistryDataPacket;

public final class RegistryCache {
    private static final Map<JavaRegistryKey<?>, Map<Key, NbtMap>> DEFAULTS;
    private static final Map<JavaRegistryKey<?>, RegistryLoader<?>> READERS;
    private final GeyserSession session;
    private final Reference2ObjectMap<JavaRegistryKey<?>, JavaRegistry<?>> registries;

    public RegistryCache(GeyserSession session) {
        this.session = session;
        this.registries = new Reference2ObjectOpenHashMap(READERS.size());
        for (JavaRegistryKey<?> registry : READERS.keySet()) {
            this.registries.put(registry, new SimpleJavaRegistry());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(ClientboundRegistryDataPacket packet) {
        JavaRegistryKey<?> registryKey = JavaRegistries.fromKey(packet.getRegistry());
        if (registryKey != null) {
            RegistryLoader<?> reader = READERS.get(registryKey);
            if (reader == null) throw new IllegalStateException("Expected reader for registry " + String.valueOf(registryKey));
            reader.load(this.session, (JavaRegistry)this.registries.get(registryKey), packet.getEntries());
            return;
        } else {
            GeyserImpl.getInstance().getLogger().debug("Ignoring registry of type " + String.valueOf(packet.getRegistry()));
        }
    }

    public <T> JavaRegistry<T> registry(JavaRegistryKey<T> registryKey) {
        if (!this.registries.containsKey(registryKey)) {
            throw new IllegalArgumentException("The given registry is not data-driven");
        }
        return (JavaRegistry)this.registries.get(registryKey);
    }

    private static <T> void register(JavaRegistryKey<T> registryKey, RegistryReader<T> reader) {
        RegistryCache.register(registryKey, (GeyserSession session, JavaRegistry<T> registry, List<RegistryEntry> entries) -> {
            Map<Key, NbtMap> localRegistry = null;
            Object2IntOpenHashMap<Key> entryIdMap = new Object2IntOpenHashMap<Key>();
            for (int i = 0; i < entries.size(); ++i) {
                entryIdMap.put(((RegistryEntry)entries.get(i)).getId(), i);
            }
            ArrayList builder = new ArrayList(entries.size());
            for (int i = 0; i < entries.size(); ++i) {
                RegistryEntryContext context;
                Object cacheEntry;
                RegistryEntry entry = (RegistryEntry)entries.get(i);
                if (entry.getData() == null) {
                    if (localRegistry == null) {
                        localRegistry = DEFAULTS.get(registryKey);
                    }
                    entry = new RegistryEntry(entry.getId(), localRegistry.get(entry.getId()));
                }
                if ((cacheEntry = reader.read(context = new RegistryEntryContext(entry, entryIdMap, session))) == null) {
                    throw new IllegalStateException("Registry reader returned null for an entry!");
                }
                builder.add(i, new RegistryEntryData(entry.getId(), cacheEntry));
            }
            registry.reset(builder);
        });
    }

    private static <T> void register(JavaRegistryKey<T> registryKey, RegistryLoader<T> reader) {
        READERS.put(registryKey, reader);
    }

    public static void init() {
    }

    static {
        READERS = new HashMap();
        RegistryCache.register(JavaRegistries.CHAT_TYPE, ChatDecoration::readChatType);
        RegistryCache.register(JavaRegistries.DIMENSION_TYPE, JavaDimension::read);
        RegistryCache.register(JavaRegistries.BIOME, BiomeTranslator::loadServerBiome);
        RegistryCache.register(JavaRegistries.ENCHANTMENT, Enchantment::read);
        RegistryCache.register(JavaRegistries.BANNER_PATTERN, (RegistryEntryContext context) -> BannerPattern.getByJavaIdentifier(context.id()));
        RegistryCache.register(JavaRegistries.INSTRUMENT, GeyserInstrument::read);
        RegistryCache.register(JavaRegistries.JUKEBOX_SONG, JukeboxSong::read);
        RegistryCache.register(JavaRegistries.PAINTING_VARIANT, (RegistryEntryContext context) -> PaintingType.getByName(context.id()));
        RegistryCache.register(JavaRegistries.TRIM_MATERIAL, TrimRecipe::readTrimMaterial);
        RegistryCache.register(JavaRegistries.TRIM_PATTERN, TrimRecipe::readTrimPattern);
        RegistryCache.register(JavaRegistries.DAMAGE_TYPE, RegistryReader.UNIT);
        RegistryCache.register(JavaRegistries.CAT_VARIANT, VariantHolder.reader(CatEntity.BuiltInVariant.class, CatEntity.BuiltInVariant.BLACK));
        RegistryCache.register(JavaRegistries.FROG_VARIANT, VariantHolder.reader(FrogEntity.BuiltInVariant.class, FrogEntity.BuiltInVariant.TEMPERATE));
        RegistryCache.register(JavaRegistries.WOLF_VARIANT, VariantHolder.reader(WolfEntity.BuiltInVariant.class, WolfEntity.BuiltInVariant.PALE));
        RegistryCache.register(JavaRegistries.WOLF_SOUND_VARIANT, RegistryReader.UNIT);
        RegistryCache.register(JavaRegistries.PIG_VARIANT, TemperatureVariantAnimal.VARIANT_READER);
        RegistryCache.register(JavaRegistries.COW_VARIANT, TemperatureVariantAnimal.VARIANT_READER);
        RegistryCache.register(JavaRegistries.CHICKEN_VARIANT, TemperatureVariantAnimal.VARIANT_READER);
        NbtMap tag = MinecraftProtocol.loadNetworkCodec();
        HashMap defaults = new HashMap();
        READERS.forEach((key, $) -> {
            List<NbtMap> rawValues = tag.getCompound(key.registryKey().asString()).getList("value", NbtType.COMPOUND);
            HashMap<Key, NbtMap> values = new HashMap<Key, NbtMap>();
            for (NbtMap value : rawValues) {
                Key name = MinecraftKey.key(value.getString("name"));
                values.put(name, value.getCompound("element"));
            }
            defaults.put(key, Map.copyOf(values));
        });
        DEFAULTS = Map.copyOf(defaults);
    }

    @FunctionalInterface
    private static interface RegistryLoader<T> {
        public void load(GeyserSession var1, JavaRegistry<T> var2, List<RegistryEntry> var3);
    }

    @FunctionalInterface
    public static interface RegistryReader<T> {
        public static final RegistryReader<RegistryUnit> UNIT = context -> RegistryUnit.INSTANCE;

        public T read(RegistryEntryContext var1);
    }
}

