/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard.display.slot;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.data.ScoreInfo;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.ScoreReference;
import org.geysermc.geyser.scoreboard.UpdateType;
import org.geysermc.geyser.scoreboard.display.score.PlayerlistDisplayScore;
import org.geysermc.geyser.scoreboard.display.slot.DisplaySlot;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreboardPosition;

public class PlayerlistDisplaySlot
extends DisplaySlot {
    private final Long2ObjectMap<PlayerlistDisplayScore> displayScores = Long2ObjectMaps.synchronize(new Long2ObjectOpenHashMap());
    private final List<PlayerlistDisplayScore> removedScores = Collections.synchronizedList(new ArrayList());

    public PlayerlistDisplaySlot(GeyserSession session, Objective objective) {
        super(session, objective, ScoreboardPosition.PLAYER_LIST);
        this.registerExisting();
    }

    @Override
    protected void render0(List<ScoreInfo> addScores, List<ScoreInfo> removeScores) {
        boolean objectiveNothing;
        boolean objectiveAdd = this.updateType == UpdateType.ADD;
        boolean objectiveUpdate = this.updateType == UpdateType.UPDATE;
        boolean bl = objectiveNothing = this.updateType == UpdateType.NOTHING;
        if (objectiveNothing) {
            ArrayList<PlayerlistDisplayScore> removedScoresCopy = new ArrayList<PlayerlistDisplayScore>(this.removedScores);
            for (PlayerlistDisplayScore removedScore : removedScoresCopy) {
                if (removedScore.cachedInfo() == null) continue;
                removeScores.add(removedScore.cachedInfo());
            }
            this.removedScores.removeAll(removedScoresCopy);
        } else {
            this.removedScores.clear();
        }
        for (PlayerlistDisplayScore score : this.displayScores.values()) {
            if (score.referenceRemoved()) {
                ScoreInfo cachedInfo = score.cachedInfo();
                if (cachedInfo == null) continue;
                removeScores.add(cachedInfo);
                continue;
            }
            boolean add = objectiveAdd || objectiveUpdate;
            boolean exists = score.exists();
            if (score.shouldUpdate()) {
                score.update(this.objective);
                add = true;
            }
            if (add) {
                addScores.add(score.cachedInfo());
            }
            if (!add || !exists || !objectiveNothing) continue;
            removeScores.add(score.cachedInfo());
        }
        if (objectiveUpdate) {
            this.sendRemoveObjective();
        }
        if (objectiveAdd || objectiveUpdate) {
            this.sendDisplayObjective();
        }
        this.updateType = UpdateType.NOTHING;
    }

    @Override
    public void addScore(ScoreReference reference) {
        List<PlayerEntity> players = this.session.getEntityCache().getPlayersByName(reference.name());
        SessionPlayerEntity selfPlayer = this.session.getPlayerEntity();
        if (reference.name().equals(selfPlayer.getUsername())) {
            players.add(selfPlayer);
        }
        for (PlayerEntity player : players) {
            PlayerlistDisplayScore score = new PlayerlistDisplayScore(this, this.objective.getScoreboard().nextId(), reference, player.getGeyserId());
            this.displayScores.put(player.getGeyserId(), score);
        }
    }

    private void registerExisting() {
        this.playerRegistered(this.session.getPlayerEntity());
        this.session.getEntityCache().getAllPlayerEntities().forEach(this::playerRegistered);
    }

    @Override
    public void playerRegistered(PlayerEntity player) {
        ScoreReference reference = this.objective.getScores().get(player.getUsername());
        if (reference == null) {
            return;
        }
        PlayerlistDisplayScore score = new PlayerlistDisplayScore(this, this.objective.getScoreboard().nextId(), reference, player.getGeyserId());
        this.displayScores.put(player.getGeyserId(), score);
    }

    @Override
    public void playerRemoved(PlayerEntity player) {
        PlayerlistDisplayScore score = (PlayerlistDisplayScore)this.displayScores.remove(player.getGeyserId());
        if (score == null) {
            return;
        }
        this.removedScores.add(score);
    }
}

