/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.standalone;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.command.standalone.StandaloneCloudCommandManager;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.configuration.GeyserJacksonConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.standalone.GeyserStandaloneConfiguration;
import org.geysermc.geyser.platform.standalone.GeyserStandaloneDumpInfo;
import org.geysermc.geyser.platform.standalone.GeyserStandaloneLogger;
import org.geysermc.geyser.platform.standalone.gui.GeyserStandaloneGUI;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.LoopbackUtil;

public class GeyserStandaloneBootstrap
implements GeyserBootstrap {
    private StandaloneCloudCommandManager cloud;
    private CommandRegistry commandRegistry;
    private GeyserStandaloneConfiguration geyserConfig;
    private final GeyserStandaloneLogger geyserLogger = new GeyserStandaloneLogger();
    private IGeyserPingPassthrough geyserPingPassthrough;
    private GeyserStandaloneGUI gui;
    private boolean useGui = System.console() == null && !this.isHeadless();
    private Logger log4jLogger;
    private String configFilename = "config.yml";
    private GeyserImpl geyser;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Map<String, String> argsConfigKeys = new HashMap<String, String>();

    public static void main(String[] args) {
        if (System.getProperty("io.netty.leakDetection.level") == null) {
            ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.DISABLED);
        }
        if (System.getProperty("io.netty.allocator.type") == null) {
            System.setProperty("io.netty.allocator.type", "pooled");
        }
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        GeyserStandaloneLogger.setupStreams();
        GeyserStandaloneBootstrap bootstrap = new GeyserStandaloneBootstrap();
        boolean useGuiOpts = bootstrap.useGui;
        String configFilenameOpt = bootstrap.configFilename;
        GeyserLocale.init(bootstrap);
        List<BeanPropertyDefinition> availableProperties = GeyserStandaloneBootstrap.getPOJOForClass(GeyserJacksonConfiguration.class);
        block16: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "--gui": 
                case "gui": {
                    useGuiOpts = true;
                    continue block16;
                }
                case "--nogui": 
                case "nogui": {
                    useGuiOpts = false;
                    continue block16;
                }
                case "--config": 
                case "-c": {
                    if (i >= args.length - 1) {
                        System.err.println(MessageFormat.format(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.config_not_specified"), "-c"));
                        return;
                    }
                    configFilenameOpt = args[i + 1];
                    ++i;
                    System.out.println(MessageFormat.format(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.config_specified"), configFilenameOpt));
                    continue block16;
                }
                case "--help": 
                case "-h": {
                    System.out.println(MessageFormat.format(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.usage"), "[java -jar] Geyser.jar [opts]"));
                    System.out.println("  " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.options"));
                    System.out.println("    -c, --config [file]    " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.config"));
                    System.out.println("    -h, --help             " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.help"));
                    System.out.println("    --gui, --nogui         " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.gui"));
                    return;
                }
                default: {
                    String[] argParts;
                    if (arg.startsWith("--") && (argParts = arg.substring(2).split("=")).length == 2) {
                        String[] configKeyParts = argParts[0].split("\\.");
                        boolean found = false;
                        block17: for (BeanPropertyDefinition property : availableProperties) {
                            if (!configKeyParts[0].equals(property.getName())) continue;
                            if (configKeyParts.length > 1) {
                                for (BeanPropertyDefinition subProperty : GeyserStandaloneBootstrap.getPOJOForClass(property.getRawPrimaryType())) {
                                    if (!configKeyParts[1].equals(subProperty.getName())) continue;
                                    found = true;
                                    break block17;
                                }
                                break;
                            }
                            found = true;
                            break;
                        }
                        if (found) {
                            argsConfigKeys.put(argParts[0], argParts[1]);
                            continue block16;
                        }
                    }
                    System.err.println(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.unrecognised", arg));
                    return;
                }
            }
        }
        bootstrap.useGui = useGuiOpts;
        bootstrap.configFilename = configFilenameOpt;
        bootstrap.onGeyserInitialize();
    }

    @Override
    public void onGeyserInitialize() {
        this.log4jLogger = (Logger)LogManager.getRootLogger();
        if (this.useGui && this.gui == null) {
            this.gui = new GeyserStandaloneGUI(this.geyserLogger);
            this.gui.addGuiAppender();
            this.gui.startUpdateThread();
        }
        LoopbackUtil.checkAndApplyLoopback(this.geyserLogger);
        this.onGeyserEnable();
    }

    @Override
    public void onGeyserEnable() {
        try {
            File configFile = FileUtils.fileOrCopiedFromResource(new File(this.configFilename), "config.yml", x -> x.replaceAll("generateduuid", UUID.randomUUID().toString()), this);
            this.geyserConfig = FileUtils.loadConfig(configFile, GeyserStandaloneConfiguration.class);
            this.handleArgsConfigOptions();
            if (this.geyserConfig.getRemote().address().equalsIgnoreCase("auto")) {
                this.geyserConfig.setAutoconfiguredRemote(true);
                this.geyserConfig.getRemote().setAddress("127.0.0.1");
            }
        }
        catch (IOException ex) {
            this.geyserLogger.severe(GeyserLocale.getLocaleStringLog("geyser.config.failed"), ex);
            if (this.gui == null) {
                System.exit(1);
            }
            return;
        }
        this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
        GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        this.log4jLogger.get().setLevel(this.geyserConfig.isDebugMode() ? Level.DEBUG : Level.INFO);
        this.geyser = GeyserImpl.load(PlatformType.STANDALONE, this);
        boolean reloading = this.geyser.isReloading();
        if (!reloading) {
            this.cloud = new StandaloneCloudCommandManager(this.geyser);
            this.commandRegistry = new CommandRegistry(this.geyser, this.cloud);
        }
        GeyserImpl.start();
        if (!reloading) {
            this.cloud.fireRegisterPermissionsEvent();
        }
        if (this.gui != null) {
            this.gui.enableCommands(this.geyser.getScheduledThread(), this.commandRegistry);
        }
        this.geyserPingPassthrough = GeyserLegacyPingPassthrough.init(this.geyser);
        this.geyserLogger.start();
    }

    private boolean isHeadless() {
        try {
            Class<?> graphicsEnv = Class.forName("java.awt.GraphicsEnvironment");
            Method isHeadless = graphicsEnv.getDeclaredMethod("isHeadless", new Class[0]);
            return (Boolean)isHeadless.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public void onGeyserDisable() {
        this.geyser.disable();
    }

    @Override
    public void onGeyserShutdown() {
        this.geyser.shutdown();
        System.exit(0);
    }

    @Override
    public GeyserConfiguration getGeyserConfig() {
        return this.geyserConfig;
    }

    @Override
    public GeyserStandaloneLogger getGeyserLogger() {
        return this.geyserLogger;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.geyserPingPassthrough;
    }

    @Override
    public Path getConfigFolder() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    @Override
    public Path getSavedUserLoginsFolder() {
        return new File(this.configFilename).getAbsoluteFile().getParentFile().toPath();
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserStandaloneDumpInfo(this);
    }

    @Override
    public @NonNull String getServerBindAddress() {
        throw new IllegalStateException();
    }

    @Override
    public int getServerPort() {
        throw new IllegalStateException();
    }

    @Override
    public boolean testFloodgatePluginPresent() {
        return false;
    }

    public static List<BeanPropertyDefinition> getPOJOForClass(Class<?> clazz) {
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructType(clazz);
        BeanDescription beanDescription = OBJECT_MAPPER.getSerializationConfig().introspect(javaType);
        List<BeanPropertyDefinition> properties = beanDescription.findProperties();
        Set<String> ignoredProperties = OBJECT_MAPPER.getSerializationConfig().getAnnotationIntrospector().findPropertyIgnoralByName(OBJECT_MAPPER.getSerializationConfig(), beanDescription.getClassInfo()).getIgnored();
        return properties.stream().filter(property -> !ignoredProperties.contains(property.getName())).collect(Collectors.toList());
    }

    private static void setConfigOption(BeanPropertyDefinition property, Object parentObject, Object value) {
        Object parsedValue = value;
        if (Integer.TYPE.equals(property.getRawPrimaryType())) {
            parsedValue = Integer.valueOf((String)parsedValue);
        } else if (Boolean.TYPE.equals(property.getRawPrimaryType())) {
            parsedValue = Boolean.valueOf((String)parsedValue);
        } else if (Enum.class.isAssignableFrom(property.getRawPrimaryType())) {
            parsedValue = Enum.valueOf(property.getRawPrimaryType(), ((String)parsedValue).toUpperCase(Locale.ROOT));
        }
        AnnotatedField field = property.getField();
        field.fixAccess(true);
        field.setValue(parentObject, parsedValue);
    }

    private void handleArgsConfigOptions() {
        List<BeanPropertyDefinition> availableProperties = GeyserStandaloneBootstrap.getPOJOForClass(GeyserJacksonConfiguration.class);
        block4: for (Map.Entry<String, String> configKey : argsConfigKeys.entrySet()) {
            String[] configKeyParts = configKey.getKey().split("\\.");
            for (BeanPropertyDefinition property : availableProperties) {
                if (!configKeyParts[0].equals(property.getName())) continue;
                if (configKeyParts.length > 1) {
                    for (BeanPropertyDefinition subProperty : GeyserStandaloneBootstrap.getPOJOForClass(property.getRawPrimaryType())) {
                        if (!configKeyParts[1].equals(subProperty.getName())) continue;
                        this.geyserLogger.info(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.set_config_option", configKey.getKey(), configKey.getValue()));
                        try {
                            Object subConfig = property.getGetter().callOn(this.geyserConfig);
                            GeyserStandaloneBootstrap.setConfigOption(subProperty, subConfig, configKey.getValue());
                        }
                        catch (Exception e) {
                            this.geyserLogger.error("Failed to set config option: " + String.valueOf(property.getFullName()));
                        }
                        continue block4;
                    }
                    continue block4;
                }
                this.geyserLogger.info(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.set_config_option", configKey.getKey(), configKey.getValue()));
                try {
                    GeyserStandaloneBootstrap.setConfigOption(property, this.geyserConfig, configKey.getValue());
                }
                catch (Exception e) {
                    this.geyserLogger.error("Failed to set config option: " + String.valueOf(property.getFullName()));
                }
            }
        }
    }

    public boolean isUseGui() {
        return this.useGui;
    }
}

