/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block;

import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBlockState;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBoundingBox;

public class GeyserJavaBlockState
implements JavaBlockState {
    String identifier;
    int javaId;
    int stateGroupId;
    float blockHardness;
    boolean waterlogged;
    JavaBoundingBox[] collision;
    boolean canBreakWithHand;
    String pickItem;
    String pistonBehavior;

    private GeyserJavaBlockState(Builder builder) {
        this.identifier = builder.identifier;
        this.javaId = builder.javaId;
        this.stateGroupId = builder.stateGroupId;
        this.blockHardness = builder.blockHardness;
        this.waterlogged = builder.waterlogged;
        this.collision = builder.collision;
        this.canBreakWithHand = builder.canBreakWithHand;
        this.pickItem = builder.pickItem;
        this.pistonBehavior = builder.pistonBehavior;
    }

    @Override
    public @NonNull String identifier() {
        return this.identifier;
    }

    @Override
    public @NonNegative int javaId() {
        return this.javaId;
    }

    @Override
    public @NonNegative int stateGroupId() {
        return this.stateGroupId;
    }

    @Override
    public @NonNegative float blockHardness() {
        return this.blockHardness;
    }

    @Override
    public boolean waterlogged() {
        return this.waterlogged;
    }

    @Override
    public @NonNull JavaBoundingBox[] collision() {
        return this.collision;
    }

    @Override
    public boolean canBreakWithHand() {
        return this.canBreakWithHand;
    }

    @Override
    public @Nullable String pickItem() {
        return this.pickItem;
    }

    @Override
    public @Nullable String pistonBehavior() {
        return this.pistonBehavior;
    }

    @Override
    public boolean hasBlockEntity() {
        return false;
    }

    public static class Builder
    implements JavaBlockState.Builder {
        private String identifier;
        private int javaId;
        private int stateGroupId;
        private float blockHardness;
        private boolean waterlogged;
        private JavaBoundingBox[] collision;
        private boolean canBreakWithHand;
        private String pickItem;
        private String pistonBehavior;

        @Override
        public Builder identifier(@NonNull String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder javaId(@NonNegative int javaId) {
            this.javaId = javaId;
            return this;
        }

        @Override
        public Builder stateGroupId(@NonNegative int stateGroupId) {
            this.stateGroupId = stateGroupId;
            return this;
        }

        @Override
        public Builder blockHardness(@NonNegative float blockHardness) {
            this.blockHardness = blockHardness;
            return this;
        }

        @Override
        public Builder waterlogged(boolean waterlogged) {
            this.waterlogged = waterlogged;
            return this;
        }

        @Override
        public Builder collision(@NonNull JavaBoundingBox[] collision) {
            this.collision = collision;
            return this;
        }

        @Override
        public Builder canBreakWithHand(boolean canBreakWithHand) {
            this.canBreakWithHand = canBreakWithHand;
            return this;
        }

        @Override
        public Builder pickItem(@Nullable String pickItem) {
            this.pickItem = pickItem;
            return this;
        }

        @Override
        public Builder pistonBehavior(@Nullable String pistonBehavior) {
            this.pistonBehavior = pistonBehavior;
            return this;
        }

        @Override
        public Builder hasBlockEntity(boolean hasBlockEntity) {
            if (this.pistonBehavior == null && hasBlockEntity) {
                this.pistonBehavior = "BLOCK";
            }
            return this;
        }

        @Override
        public JavaBlockState build() {
            return new GeyserJavaBlockState(this);
        }
    }
}

