/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.standalone;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.permission.PermissionChecker;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.command.standalone.PermissionConfiguration;
import org.geysermc.geyser.util.FileUtils;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.internal.CommandRegistrationHandler;

public class StandaloneCloudCommandManager
extends CommandManager<GeyserCommandSource> {
    private final GeyserImpl geyser;
    private final List<PermissionChecker> permissionCheckers = new ArrayList<PermissionChecker>();
    private final Set<String> basePermissions = new ObjectOpenHashSet<String>();

    public StandaloneCloudCommandManager(GeyserImpl geyser) {
        super(ExecutionCoordinator.simpleCoordinator(), CommandRegistrationHandler.nullCommandRegistrationHandler());
        this.geyser = geyser;
        geyser.getEventBus().fire(this.permissionCheckers::add);
        try {
            File permissionsFile = geyser.getBootstrap().getConfigFolder().resolve("permissions.yml").toFile();
            FileUtils.fileOrCopiedFromResource(permissionsFile, "permissions.yml", geyser.getBootstrap());
            PermissionConfiguration config = FileUtils.loadConfig(permissionsFile, PermissionConfiguration.class);
            this.basePermissions.addAll(config.getDefaultPermissions());
        }
        catch (Exception e) {
            geyser.getLogger().error("Failed to load permissions.yml - proceeding without it", e);
        }
    }

    public void fireRegisterPermissionsEvent() {
        this.geyser.getEventBus().fire((permission, def) -> {
            Objects.requireNonNull(permission, "permission");
            Objects.requireNonNull(def, "permission default for " + permission);
            if (permission.isBlank()) {
                return;
            }
            if (def == TriState.TRUE) {
                this.basePermissions.add(permission);
            }
        });
    }

    @Override
    public boolean hasPermission(@NonNull GeyserCommandSource sender, @NonNull String permission) {
        if (sender.isConsole()) {
            return true;
        }
        if (permission.isBlank()) {
            return true;
        }
        for (PermissionChecker checker : this.permissionCheckers) {
            Boolean result = checker.hasPermission(sender, permission).toBoolean();
            if (result == null) continue;
            return result;
        }
        return this.basePermissions.contains(permission);
    }
}

