/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.key.CloudKey;
import org.incendo.cloud.permission.Permission;
import org.incendo.cloud.permission.PermissionResult;
import org.incendo.cloud.permission.PredicatePermission;

public class GeyserPermission
implements PredicatePermission<GeyserCommandSource> {
    private final boolean bedrockOnly;
    private final boolean playerOnly;
    private final String permission;
    private final CommandManager<GeyserCommandSource> manager;

    public @NonNull Result testPermission(@NonNull GeyserCommandSource source) {
        if (this.bedrockOnly) {
            if (source.connection() == null) {
                return new Result(Result.Meta.NOT_BEDROCK);
            }
        } else if (this.playerOnly && source.isConsole()) {
            return new Result(Result.Meta.NOT_PLAYER);
        }
        if (this.permission.isBlank() || this.manager.hasPermission(source, this.permission)) {
            return new Result(Result.Meta.ALLOWED);
        }
        return new Result(Result.Meta.NO_PERMISSION);
    }

    @Override
    public @NonNull CloudKey<Void> key() {
        return CloudKey.cloudKey(this.permission);
    }

    public GeyserPermission(boolean bedrockOnly, boolean playerOnly, String permission, CommandManager<GeyserCommandSource> manager) {
        this.bedrockOnly = bedrockOnly;
        this.playerOnly = playerOnly;
        this.permission = permission;
        this.manager = manager;
    }

    public final class Result
    implements PermissionResult {
        private final Meta meta;

        private Result(Meta meta) {
            this.meta = meta;
        }

        public Meta meta() {
            return this.meta;
        }

        @Override
        public boolean allowed() {
            return this.meta == Meta.ALLOWED;
        }

        @Override
        public @NonNull Permission permission() {
            return GeyserPermission.this;
        }

        public static enum Meta {
            NOT_BEDROCK,
            NOT_PLAYER,
            NO_PERMISSION,
            ALLOWED;

        }
    }
}

