/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.form.impl.custom;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.cumulus.component.Component;
import org.geysermc.cumulus.component.DropdownComponent;
import org.geysermc.cumulus.component.InputComponent;
import org.geysermc.cumulus.component.LabelComponent;
import org.geysermc.cumulus.component.SliderComponent;
import org.geysermc.cumulus.component.StepSliderComponent;
import org.geysermc.cumulus.component.ToggleComponent;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.impl.FormImpl;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.cumulus.util.FormImage;

public final class CustomFormImpl
extends FormImpl<CustomFormResponse>
implements CustomForm {
    private final FormImage icon;
    private final List<Component> content;

    public CustomFormImpl(@NonNull String title, @Nullable FormImage icon, @NonNull List<Component> content) {
        super(title);
        this.icon = icon;
        this.content = Collections.unmodifiableList(content);
    }

    @Override
    public @NonNull FormImage icon() {
        return this.icon;
    }

    @Override
    public @NonNull List<Component> content() {
        return this.content;
    }

    public static final class Builder
    extends FormImpl.Builder<CustomForm.Builder, CustomForm, CustomFormResponse>
    implements CustomForm.Builder {
        private final List<Component> components = new ArrayList<Component>();
        private FormImage icon;

        @Override
        public Builder icon(@NonNull FormImage image) {
            this.icon = Objects.requireNonNull(image, "image");
            return this;
        }

        @Override
        public Builder icon(@NonNull FormImage.Type type, @NonNull String data) {
            this.icon = FormImage.of(type, data);
            return this;
        }

        @Override
        public Builder iconPath(@NonNull String path) {
            return this.icon(FormImage.Type.PATH, path);
        }

        @Override
        public Builder iconUrl(@NonNull String url) {
            return this.icon(FormImage.Type.URL, url);
        }

        @Override
        public Builder component(@NonNull Component component) {
            this.components.add(Objects.requireNonNull(component, "component"));
            return this;
        }

        @Override
        public Builder optionalComponent(@NonNull Component component, boolean shouldAdd) {
            if (shouldAdd) {
                return this.component(component);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder dropdown(@NonNull DropdownComponent.Builder dropdownBuilder) {
            Objects.requireNonNull(dropdownBuilder, "dropdownBuilder");
            return this.component(dropdownBuilder.translateAndBuild(this::translate));
        }

        @Override
        public Builder dropdown(@NonNull String text, @NonNull List<String> options, @NonNegative int defaultOption) {
            Objects.requireNonNull(text, "text");
            Preconditions.checkArgument(defaultOption >= 0, "defaultOption");
            ArrayList<String> optionsList = new ArrayList<String>();
            for (String option : options) {
                optionsList.add(this.translate(option));
            }
            return this.component(DropdownComponent.of(this.translate(text), optionsList, defaultOption));
        }

        @Override
        public Builder dropdown(@NonNull String text, int defaultOption, String ... options) {
            return this.dropdown(text, (List)Arrays.asList(options), defaultOption);
        }

        @Override
        public Builder dropdown(@NonNull String text, @NonNull List<String> options) {
            return this.dropdown(text, (List)options, 0);
        }

        @Override
        public Builder dropdown(@NonNull String text, String ... options) {
            return this.dropdown(text, (List)Arrays.asList(options), 0);
        }

        @Override
        public Builder optionalDropdown(@NonNull String text, @NonNull List<String> options, @NonNegative int defaultOption, boolean shouldAdd) {
            if (shouldAdd) {
                return this.dropdown(text, (List)options, defaultOption);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder optionalDropdown(boolean shouldAdd, @NonNull String text, @NonNegative int defaultOption, String ... options) {
            return this.optionalDropdown(text, (List)Arrays.asList(options), defaultOption, shouldAdd);
        }

        @Override
        public Builder optionalDropdown(@NonNull String text, @NonNull List<String> options, boolean shouldAdd) {
            if (shouldAdd) {
                return this.dropdown(text, (List)options);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder optionalDropdown(boolean shouldAdd, @NonNull String text, String ... options) {
            return this.optionalDropdown(text, (List)Arrays.asList(options), shouldAdd);
        }

        @Override
        public Builder input(@NonNull String text, @NonNull String placeholder, @NonNull String defaultText) {
            return this.component(InputComponent.of(this.translate(text), this.translate(placeholder), this.translate(defaultText)));
        }

        @Override
        public Builder input(@NonNull String text, @NonNull String placeholder) {
            return this.component(InputComponent.of(this.translate(text), this.translate(placeholder)));
        }

        @Override
        public Builder input(@NonNull String text) {
            return this.component(InputComponent.of(this.translate(text)));
        }

        @Override
        public Builder optionalInput(@NonNull String text, @NonNull String placeholder, @NonNull String defaultText, boolean shouldAdd) {
            if (shouldAdd) {
                return this.input(text, placeholder, defaultText);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder optionalInput(@NonNull String text, @NonNull String placeholder, boolean shouldAdd) {
            if (shouldAdd) {
                return this.input(text, placeholder);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder optionalInput(@NonNull String text, boolean shouldAdd) {
            if (shouldAdd) {
                return this.input(text);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder label(@NonNull String text) {
            return this.component(LabelComponent.of(this.translate(text)));
        }

        @Override
        public Builder optionalLabel(@NonNull String text, boolean shouldAdd) {
            if (shouldAdd) {
                return this.label(text);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder slider(@NonNull String text, float min, float max, @Positive float step, float defaultValue) {
            return this.component(SliderComponent.of(text, min, max, step, defaultValue));
        }

        @Override
        public Builder slider(@NonNull String text, float min, float max, @Positive float step) {
            return this.component(SliderComponent.of(text, min, max, step));
        }

        @Override
        public Builder slider(@NonNull String text, float min, float max) {
            return this.slider(text, min, max, 1.0f);
        }

        @Override
        public Builder optionalSlider(@NonNull String text, float min, float max, @Positive float step, float defaultValue, boolean shouldAdd) {
            if (shouldAdd) {
                return this.slider(text, min, max, step, defaultValue);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder optionalSlider(@NonNull String text, float min, float max, @Positive float step, boolean shouldAdd) {
            if (shouldAdd) {
                return this.slider(text, min, max, step);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder optionalSlider(@NonNull String text, float min, float max, boolean shouldAdd) {
            if (shouldAdd) {
                return this.slider(text, min, max);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder stepSlider(@NonNull StepSliderComponent.Builder stepSliderBuilder) {
            Objects.requireNonNull(stepSliderBuilder, "stepSliderBuilder");
            return this.component(stepSliderBuilder.translateAndBuild(this::translate));
        }

        @Override
        public Builder stepSlider(@NonNull String text, @NonNull List<String> steps, @NonNegative int defaultStep) {
            Objects.requireNonNull(text, "text");
            Preconditions.checkArgument(defaultStep >= 0, "defaultStep");
            ArrayList<String> stepsList = new ArrayList<String>();
            for (String option : steps) {
                stepsList.add(this.translate(option));
            }
            return this.component(StepSliderComponent.of(this.translate(text), stepsList, defaultStep));
        }

        @Override
        public Builder stepSlider(@NonNull String text, int defaultStep, String ... steps) {
            return this.stepSlider(text, (List)Arrays.asList(steps), defaultStep);
        }

        @Override
        public Builder stepSlider(@NonNull String text, @NonNull List<String> steps) {
            return this.stepSlider(text, (List)steps, 0);
        }

        @Override
        public Builder stepSlider(@NonNull String text, String ... steps) {
            return this.stepSlider(text, (List)Arrays.asList(steps));
        }

        @Override
        public Builder optionalStepSlider(@NonNull String text, @NonNull List<String> steps, @NonNegative int defaultStep, boolean shouldAdd) {
            if (shouldAdd) {
                return this.stepSlider(text, (List)steps, defaultStep);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder optionalStepSlider(boolean shouldAdd, @NonNull String text, @NonNegative int defaultStep, String ... steps) {
            return this.optionalStepSlider(text, (List)Arrays.asList(steps), defaultStep, shouldAdd);
        }

        @Override
        public Builder optionalStepSlider(@NonNull String text, @NonNull List<String> steps, boolean shouldAdd) {
            if (shouldAdd) {
                return this.stepSlider(text, (List)steps);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder optionalStepSlider(boolean shouldAdd, @NonNull String text, String ... steps) {
            return this.optionalStepSlider(text, (List)Arrays.asList(steps), shouldAdd);
        }

        @Override
        public Builder toggle(@NonNull String text, boolean defaultValue) {
            return this.component(ToggleComponent.of(this.translate(text), defaultValue));
        }

        @Override
        public Builder toggle(@NonNull String text) {
            return this.component(ToggleComponent.of(this.translate(text)));
        }

        @Override
        public Builder optionalToggle(@NonNull String text, boolean defaultValue, boolean shouldAdd) {
            if (shouldAdd) {
                return this.toggle(text, defaultValue);
            }
            return this.addNullComponent();
        }

        @Override
        public Builder optionalToggle(@NonNull String text, boolean shouldAdd) {
            if (shouldAdd) {
                return this.toggle(text);
            }
            return this.addNullComponent();
        }

        @Override
        public @NonNull CustomForm build() {
            CustomFormImpl form = new CustomFormImpl(this.title, this.icon, this.components);
            this.setResponseHandler(form, form);
            return form;
        }

        private Builder addNullComponent() {
            this.components.add(null);
            return this;
        }
    }
}

