/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.codec.v390;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.EntityDataTypeMap;
import org.cloudburstmc.protocol.bedrock.codec.v388.BedrockCodecHelper_v388;
import org.cloudburstmc.protocol.bedrock.data.skin.AnimationData;
import org.cloudburstmc.protocol.bedrock.data.skin.ImageData;
import org.cloudburstmc.protocol.bedrock.data.skin.PersonaPieceData;
import org.cloudburstmc.protocol.bedrock.data.skin.PersonaPieceTintData;
import org.cloudburstmc.protocol.bedrock.data.skin.SerializedSkin;
import org.cloudburstmc.protocol.common.util.TypeMap;

public class BedrockCodecHelper_v390
extends BedrockCodecHelper_v388 {
    public BedrockCodecHelper_v390(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes) {
        super(entityData, gameRulesTypes);
    }

    @Override
    public SerializedSkin readSkin(ByteBuf buffer) {
        String skinId = this.readString(buffer);
        String skinResourcePatch = this.readString(buffer);
        ImageData skinData = this.readImage(buffer, 262144);
        ObjectArrayList<AnimationData> animations = new ObjectArrayList<AnimationData>();
        this.readArray(buffer, animations, ByteBuf::readIntLE, (ByteBuf b, BedrockCodecHelper h) -> this.readAnimationData((ByteBuf)b));
        ImageData capeData = this.readImage(buffer, 8192);
        String geometryData = this.readStringMaxLen(buffer, 262144);
        String animationData = this.readString(buffer);
        boolean premium = buffer.readBoolean();
        boolean persona = buffer.readBoolean();
        boolean capeOnClassic = buffer.readBoolean();
        String capeId = this.readString(buffer);
        String fullSkinId = this.readString(buffer);
        String armSize = this.readString(buffer);
        String skinColor = this.readString(buffer);
        ObjectArrayList<PersonaPieceData> personaPieces = new ObjectArrayList<PersonaPieceData>();
        this.readArray(buffer, personaPieces, ByteBuf::readIntLE, (ByteBuf buf, BedrockCodecHelper h) -> {
            String pieceId = this.readString((ByteBuf)buf);
            String pieceType = this.readString((ByteBuf)buf);
            String packId = this.readString((ByteBuf)buf);
            boolean isDefault = buf.readBoolean();
            String productId = this.readString((ByteBuf)buf);
            return new PersonaPieceData(pieceId, pieceType, packId, isDefault, productId);
        });
        ObjectArrayList<PersonaPieceTintData> tintColors = new ObjectArrayList<PersonaPieceTintData>();
        this.readArray(buffer, tintColors, ByteBuf::readIntLE, (ByteBuf buf, BedrockCodecHelper h) -> {
            String pieceType = this.readString((ByteBuf)buf);
            ObjectArrayList<String> colors = new ObjectArrayList<String>();
            int colorsLength = buf.readIntLE();
            for (int i2 = 0; i2 < colorsLength; ++i2) {
                colors.add(this.readString((ByteBuf)buf));
            }
            return new PersonaPieceTintData(pieceType, colors);
        });
        return SerializedSkin.of(skinId, "", skinResourcePatch, skinData, animations, capeData, geometryData, animationData, premium, persona, capeOnClassic, capeId, fullSkinId, armSize, skinColor, personaPieces, tintColors);
    }

    @Override
    public void writeSkin(ByteBuf buffer, SerializedSkin skin) {
        Objects.requireNonNull(skin, "Skin is null");
        this.writeString(buffer, skin.getSkinId());
        this.writeString(buffer, skin.getSkinResourcePatch());
        this.writeImage(buffer, skin.getSkinData());
        List<AnimationData> animations = skin.getAnimations();
        buffer.writeIntLE(animations.size());
        for (AnimationData animationData : animations) {
            this.writeAnimationData(buffer, animationData);
        }
        this.writeImage(buffer, skin.getCapeData());
        this.writeString(buffer, skin.getGeometryData());
        this.writeString(buffer, skin.getAnimationData());
        buffer.writeBoolean(skin.isPremium());
        buffer.writeBoolean(skin.isPersona());
        buffer.writeBoolean(skin.isCapeOnClassic());
        this.writeString(buffer, skin.getCapeId());
        this.writeString(buffer, skin.getFullSkinId());
        this.writeString(buffer, skin.getArmSize());
        this.writeString(buffer, skin.getSkinColor());
        List<PersonaPieceData> pieces = skin.getPersonaPieces();
        buffer.writeIntLE(pieces.size());
        for (PersonaPieceData piece : pieces) {
            this.writeString(buffer, piece.getId());
            this.writeString(buffer, piece.getType());
            this.writeString(buffer, piece.getPackId());
            buffer.writeBoolean(piece.isDefault());
            this.writeString(buffer, piece.getProductId());
        }
        List<PersonaPieceTintData> list = skin.getTintColors();
        buffer.writeIntLE(list.size());
        for (PersonaPieceTintData tint : list) {
            this.writeString(buffer, tint.getType());
            List<String> colors = tint.getColors();
            buffer.writeIntLE(colors.size());
            for (String color : colors) {
                this.writeString(buffer, color);
            }
        }
    }
}

