/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.SKULL})
public class SkullBlockEntityTranslator
extends BlockEntityTranslator
implements RequiresBlockState {
    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, BlockState blockState) {
        Integer rotation = blockState.getValue(Properties.ROTATION_16);
        if (rotation != null) {
            bedrockNbt.putFloat("Rotation", (float)rotation.intValue() * 22.5f);
        }
        if (blockState.getValue(Properties.POWERED).booleanValue()) {
            bedrockNbt.putBoolean("MouthMoving", true);
        }
    }

    private static UUID getUUID(NbtMap profile) {
        int[] uuidAsArray = profile.getIntArray("id");
        if (uuidAsArray.length == 4) {
            return new UUID((long)uuidAsArray[0] << 32 | (long)uuidAsArray[1] & 0xFFFFFFFFL, (long)uuidAsArray[2] << 32 | (long)uuidAsArray[3] & 0xFFFFFFFFL);
        }
        String username = null;
        String nameTag = profile.getString("name", null);
        if (nameTag != null) {
            username = nameTag.toLowerCase(Locale.ROOT);
        }
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
    }

    private static CompletableFuture<@Nullable String> getTextures(NbtMap profile, UUID uuid) {
        List properties = profile.getList("properties", NbtType.COMPOUND);
        if (properties.isEmpty()) {
            if (uuid != null && uuid.version() == 4) {
                String uuidString = uuid.toString().replace("-", "");
                return SkinProvider.requestTexturesFromUUID(uuidString);
            }
            String nameTag = profile.getString("name", null);
            if (nameTag != null) {
                return SkinProvider.requestTexturesFromUsername(nameTag);
            }
            return CompletableFuture.completedFuture(null);
        }
        NbtMap tag1 = (NbtMap)properties.get(0);
        String texture = tag1.getString("value", null);
        return CompletableFuture.completedFuture(texture);
    }

    public static @Nullable BlockDefinition translateSkull(GeyserSession session, NbtMap javaNbt, Vector3i blockPosition, BlockState blockState) {
        NbtMap profile = javaNbt.getCompound("profile");
        if (profile.isEmpty()) {
            session.getSkullCache().removeSkull(blockPosition);
            return null;
        }
        UUID uuid = SkullBlockEntityTranslator.getUUID(profile);
        CompletableFuture<String> texturesFuture = SkullBlockEntityTranslator.getTextures(profile, uuid);
        if (texturesFuture.isDone()) {
            try {
                String texture = texturesFuture.get();
                if (texture == null) {
                    session.getGeyser().getLogger().debug("Custom skull with invalid profile tag: " + String.valueOf(blockPosition) + " " + String.valueOf(javaNbt));
                    return null;
                }
                SkullCache.Skull skull = session.getSkullCache().putSkull(blockPosition, uuid, texture, blockState);
                return skull.getBlockDefinition();
            }
            catch (InterruptedException | ExecutionException e) {
                session.getGeyser().getLogger().debug("Failed to acquire textures for custom skull: " + String.valueOf(blockPosition) + " " + String.valueOf(javaNbt));
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        texturesFuture.whenComplete((texturesProperty, throwable) -> {
            if (texturesProperty == null) {
                session.getGeyser().getLogger().debug("Custom skull with invalid profile tag: " + String.valueOf(blockPosition) + " " + String.valueOf(javaNbt));
                return;
            }
            session.ensureInEventLoop(() -> SkullBlockEntityTranslator.putSkull(session, blockPosition, uuid, texturesProperty, blockState));
        });
        return null;
    }

    private static void putSkull(GeyserSession session, Vector3i blockPosition, UUID uuid, String texturesProperty, BlockState blockState) {
        SkullCache.Skull skull = session.getSkullCache().putSkull(blockPosition, uuid, texturesProperty, blockState);
        if (skull.getBlockDefinition() != null) {
            UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
            updateBlockPacket.setDataLayer(0);
            updateBlockPacket.setBlockPosition(blockPosition);
            updateBlockPacket.setDefinition(skull.getBlockDefinition());
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
            session.sendUpstreamPacket((BedrockPacket)updateBlockPacket);
        }
    }
}

