/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision;

import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="glass_pane$|iron_bars$", usesParams=true, passDefaultBoxes=true)
public class GlassPaneAndIronBarsCollision
extends BlockCollision {
    private int facing;

    public GlassPaneAndIronBarsCollision(BlockState state, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
        if (state.getValue(Properties.NORTH).booleanValue() && state.getValue(Properties.EAST).booleanValue()) {
            this.facing = 5;
        } else if (state.getValue(Properties.EAST).booleanValue() && state.getValue(Properties.SOUTH).booleanValue()) {
            this.facing = 6;
        } else if (state.getValue(Properties.SOUTH).booleanValue() && state.getValue(Properties.WEST).booleanValue()) {
            this.facing = 7;
        } else if (state.getValue(Properties.WEST).booleanValue() && state.getValue(Properties.NORTH).booleanValue()) {
            this.facing = 8;
        } else if (state.getValue(Properties.NORTH).booleanValue()) {
            this.facing = 1;
        } else if (state.getValue(Properties.EAST).booleanValue()) {
            this.facing = 2;
        } else if (state.getValue(Properties.SOUTH).booleanValue()) {
            this.facing = 3;
        } else if (state.getValue(Properties.WEST).booleanValue()) {
            this.facing = 4;
        }
    }

    @Override
    public boolean correctPosition(GeyserSession session, int x, int y, int z, BoundingBox playerCollision) {
        boolean result = super.correctPosition(session, x, y, z, playerCollision);
        playerCollision.setSizeX(playerCollision.getSizeX() - 1.0E-4);
        playerCollision.setSizeY(playerCollision.getSizeY() - 1.0E-4);
        playerCollision.setSizeZ(playerCollision.getSizeZ() - 1.0E-4);
        if (this.checkIntersection(x, y, z, playerCollision)) {
            double newMiddleX = x;
            double newMiddleZ = z;
            switch (this.facing) {
                case 1: {
                    newMiddleZ += 0.8625;
                    break;
                }
                case 2: {
                    newMiddleX += 0.1375;
                    break;
                }
                case 3: {
                    newMiddleZ += 0.1375;
                    break;
                }
                case 4: {
                    newMiddleX += 0.8625;
                    break;
                }
                case 5: {
                    newMiddleZ += 0.8625;
                    newMiddleX += 0.1375;
                    break;
                }
                case 6: {
                    newMiddleX += 0.1375;
                    newMiddleZ += 0.1375;
                    break;
                }
                case 7: {
                    newMiddleZ += 0.1375;
                    newMiddleX += 0.8625;
                    break;
                }
                case 8: {
                    newMiddleX += 0.8625;
                    newMiddleZ += 0.8625;
                }
            }
            playerCollision.setMiddleX(newMiddleX);
            playerCollision.setMiddleZ(newMiddleZ);
        }
        playerCollision.setSizeX(playerCollision.getSizeX() + 1.0E-4);
        playerCollision.setSizeY(playerCollision.getSizeY() + 1.0E-4);
        playerCollision.setSizeZ(playerCollision.getSizeZ() + 1.0E-4);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlassPaneAndIronBarsCollision)) {
            return false;
        }
        GlassPaneAndIronBarsCollision other = (GlassPaneAndIronBarsCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.facing == other.facing;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GlassPaneAndIronBarsCollision;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.facing;
        return result;
    }
}

