/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.lenni0451.commons.httpclient.HttpClient;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.java.session.StepFullJavaSession;
import net.raphimc.minecraftauth.step.msa.StepMsaDeviceCode;
import net.raphimc.minecraftauth.util.logging.ILogger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.util.MinecraftAuthLogger;

public class PendingMicrosoftAuthentication {
    public static final HttpClient AUTH_CLIENT = MinecraftAuth.createHttpClient();
    public static final BiFunction<Boolean, Integer, StepFullJavaSession> AUTH_FLOW = (offlineAccess, timeoutSec) -> MinecraftAuth.builder().withClientId("204cefd1-4818-4de1-b98d-513fae875d88").withScope(offlineAccess != false ? "XboxLive.signin XboxLive.offline_access" : "XboxLive.signin").withTimeout(timeoutSec.intValue()).deviceCode().withoutDeviceToken().regularAuthentication("rp://api.minecraftservices.com/").buildMinecraftJavaProfileStep(false);
    private boolean storeServerInformation = false;
    private final LoadingCache<String, AuthenticationTask> authentications;

    public PendingMicrosoftAuthentication(final int timeoutSeconds) {
        this.authentications = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AuthenticationTask>(){

            public AuthenticationTask load(@NonNull String userKey) {
                return PendingMicrosoftAuthentication.this.storeServerInformation ? new ProxyAuthenticationTask(userKey, timeoutSeconds) : new AuthenticationTask(userKey, timeoutSeconds);
            }
        });
    }

    public AuthenticationTask getTask(@NonNull String userKey) {
        return (AuthenticationTask)this.authentications.getIfPresent((Object)userKey);
    }

    public AuthenticationTask getOrCreateTask(@NonNull String userKey) {
        return (AuthenticationTask)this.authentications.get((Object)userKey);
    }

    public void setStoreServerInformation() {
        this.storeServerInformation = true;
    }

    public class AuthenticationTask {
        private static final Executor DELAYED_BY_ONE_SECOND = CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS);
        private final String userKey;
        private final int timeoutSec;
        private CompletableFuture<StepChainResult> authentication;

        private AuthenticationTask(String userKey, int timeoutSec) {
            this.userKey = userKey;
            this.timeoutSec = timeoutSec;
        }

        public void resetRunningFlow() {
            if (this.authentication == null) {
                return;
            }
            this.authentication.cancel(true);
        }

        public void cleanup() {
            GeyserLogger logger = GeyserImpl.getInstance().getLogger();
            if (logger.isDebug()) {
                logger.debug("Cleaning up authentication task for " + this.userKey);
            }
            PendingMicrosoftAuthentication.this.authentications.invalidate((Object)this.userKey);
        }

        public CompletableFuture<StepChainResult> performLoginAttempt(boolean offlineAccess, Consumer<StepMsaDeviceCode.MsaDeviceCode> deviceCodeConsumer) {
            this.authentication = CompletableFuture.supplyAsync(() -> {
                try {
                    StepFullJavaSession step = AUTH_FLOW.apply(offlineAccess, this.timeoutSec);
                    return new StepChainResult(step, (StepFullJavaSession.FullJavaSession)step.getFromInput((ILogger)MinecraftAuthLogger.INSTANCE, AUTH_CLIENT, (AbstractStep.InitialInput)new StepMsaDeviceCode.MsaDeviceCodeCallback(deviceCodeConsumer)));
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }, DELAYED_BY_ONE_SECOND).whenComplete((r, ex) -> CompletableFuture.delayedExecutor(this.timeoutSec, TimeUnit.SECONDS).execute(this::cleanup));
            return this.authentication;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{userKey='" + this.userKey + "'}";
        }

        public CompletableFuture<StepChainResult> getAuthentication() {
            return this.authentication;
        }
    }

    public record StepChainResult(StepFullJavaSession step, StepFullJavaSession.FullJavaSession session) {
    }

    public final class ProxyAuthenticationTask
    extends AuthenticationTask {
        private String server;
        private int port;

        private ProxyAuthenticationTask(String userKey, int timeoutSec) {
            super(userKey, timeoutSec);
        }

        public String getServer() {
            return this.server;
        }

        public int getPort() {
            return this.port;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

