/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard.display.slot;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.ScoreInfo;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.RemoveObjectivePacket;
import org.cloudburstmc.protocol.bedrock.packet.SetDisplayObjectivePacket;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.ScoreReference;
import org.geysermc.geyser.scoreboard.UpdateType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreboardPosition;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.TeamColor;

public abstract class DisplaySlot {
    protected final GeyserSession session;
    protected final Objective objective;
    protected final String objectiveId;
    protected final ScoreboardPosition slot;
    protected final TeamColor teamColor;
    protected final String positionName;
    protected UpdateType updateType = UpdateType.ADD;

    public DisplaySlot(GeyserSession session, Objective objective, ScoreboardPosition slot) {
        this.session = session;
        this.objective = objective;
        this.objectiveId = String.valueOf(objective.getScoreboard().nextId());
        this.slot = slot;
        this.teamColor = DisplaySlot.teamColor(slot);
        this.positionName = DisplaySlot.positionName(slot);
    }

    public final void render(List<ScoreInfo> addScores, List<ScoreInfo> removeScores) {
        if (this.updateType == UpdateType.REMOVE) {
            return;
        }
        this.render0(addScores, removeScores);
    }

    protected abstract void render0(List<ScoreInfo> var1, List<ScoreInfo> var2);

    public abstract void addScore(ScoreReference var1);

    public abstract void playerRegistered(PlayerEntity var1);

    public abstract void playerRemoved(PlayerEntity var1);

    public void remove() {
        this.updateType = UpdateType.REMOVE;
        this.sendRemoveObjective();
    }

    public void markNeedsUpdate() {
        if (this.updateType == UpdateType.NOTHING) {
            this.updateType = UpdateType.UPDATE;
        }
    }

    protected void sendDisplayObjective() {
        SetDisplayObjectivePacket packet = new SetDisplayObjectivePacket();
        packet.setObjectiveId(this.objectiveId());
        packet.setDisplayName(this.objective.getDisplayName());
        packet.setCriteria("dummy");
        packet.setDisplaySlot(this.positionName);
        packet.setSortOrder(1);
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    protected void sendRemoveObjective() {
        RemoveObjectivePacket packet = new RemoveObjectivePacket();
        packet.setObjectiveId(this.objectiveId());
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    public Objective objective() {
        return this.objective;
    }

    public String objectiveId() {
        return this.objectiveId;
    }

    public ScoreboardPosition position() {
        return this.slot;
    }

    public @Nullable TeamColor teamColor() {
        return this.teamColor;
    }

    public UpdateType updateType() {
        return this.updateType;
    }

    public static ScoreboardPosition slotCategory(ScoreboardPosition slot) {
        return switch (slot) {
            case ScoreboardPosition.BELOW_NAME -> ScoreboardPosition.BELOW_NAME;
            case ScoreboardPosition.PLAYER_LIST -> ScoreboardPosition.PLAYER_LIST;
            default -> ScoreboardPosition.SIDEBAR;
        };
    }

    private static String positionName(ScoreboardPosition slot) {
        return switch (slot) {
            case ScoreboardPosition.BELOW_NAME -> "belowname";
            case ScoreboardPosition.PLAYER_LIST -> "list";
            default -> "sidebar";
        };
    }

    private static @Nullable TeamColor teamColor(ScoreboardPosition slot) {
        return switch (slot) {
            case ScoreboardPosition.SIDEBAR_TEAM_RED -> TeamColor.RED;
            case ScoreboardPosition.SIDEBAR_TEAM_AQUA -> TeamColor.AQUA;
            case ScoreboardPosition.SIDEBAR_TEAM_BLUE -> TeamColor.BLUE;
            case ScoreboardPosition.SIDEBAR_TEAM_GOLD -> TeamColor.GOLD;
            case ScoreboardPosition.SIDEBAR_TEAM_GRAY -> TeamColor.GRAY;
            case ScoreboardPosition.SIDEBAR_TEAM_BLACK -> TeamColor.BLACK;
            case ScoreboardPosition.SIDEBAR_TEAM_GREEN -> TeamColor.GREEN;
            case ScoreboardPosition.SIDEBAR_TEAM_WHITE -> TeamColor.WHITE;
            case ScoreboardPosition.SIDEBAR_TEAM_YELLOW -> TeamColor.YELLOW;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_RED -> TeamColor.DARK_RED;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_AQUA -> TeamColor.DARK_AQUA;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_BLUE -> TeamColor.DARK_BLUE;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_GRAY -> TeamColor.DARK_GRAY;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_GREEN -> TeamColor.DARK_GREEN;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_PURPLE -> TeamColor.DARK_PURPLE;
            case ScoreboardPosition.SIDEBAR_TEAM_LIGHT_PURPLE -> TeamColor.LIGHT_PURPLE;
            default -> null;
        };
    }
}

