/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.Set;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.protocol.bedrock.data.InputMode;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerState;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundPlayerInputPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerCommandPacket;

public final class InputCache {
    private final GeyserSession session;
    private ServerboundPlayerInputPacket inputPacket = new ServerboundPlayerInputPacket(false, false, false, false, false, false, false);
    private boolean lastHorizontalCollision;
    private int ticksSinceLastMovePacket;
    private int jumpingTicks;
    private float jumpScale;
    private @MonotonicNonNull InputMode inputMode;

    public InputCache(GeyserSession session) {
        this.session = session;
    }

    public void processInputs(SessionPlayerEntity entity, PlayerAuthInputPacket packet) {
        boolean sneaking;
        boolean right;
        boolean left;
        boolean down;
        boolean up;
        Set<PlayerAuthInputData> bedrockInput = packet.getInputData();
        ServerboundPlayerInputPacket oldInputPacket = this.inputPacket;
        this.inputMode = packet.getInputMode();
        if (this.inputMode == InputMode.MOUSE) {
            up = bedrockInput.contains((Object)PlayerAuthInputData.UP);
            down = bedrockInput.contains((Object)PlayerAuthInputData.DOWN);
            left = bedrockInput.contains((Object)PlayerAuthInputData.LEFT);
            right = bedrockInput.contains((Object)PlayerAuthInputData.RIGHT);
        } else {
            Vector2f analogMovement = packet.getAnalogMoveVector();
            up = analogMovement.getY() > 0.0f;
            down = analogMovement.getY() < 0.0f;
            left = analogMovement.getX() > 0.0f;
            right = analogMovement.getX() < 0.0f;
        }
        this.inputPacket = this.inputPacket.withForward(up).withBackward(down).withLeft(left).withRight(right).withJump(bedrockInput.contains((Object)PlayerAuthInputData.JUMP_CURRENT_RAW) || bedrockInput.contains((Object)PlayerAuthInputData.JUMP_DOWN)).withShift(bedrockInput.contains((Object)PlayerAuthInputData.SNEAK_CURRENT_RAW) || bedrockInput.contains((Object)PlayerAuthInputData.SNEAK_DOWN)).withSprint(bedrockInput.contains((Object)PlayerAuthInputData.SPRINT_DOWN));
        boolean bl = sneaking = bedrockInput.contains((Object)PlayerAuthInputData.SNEAKING) || bedrockInput.contains((Object)PlayerAuthInputData.DESCEND_BLOCK) && bedrockInput.contains((Object)PlayerAuthInputData.PERSIST_SNEAK);
        if (oldInputPacket.isShift() != sneaking) {
            if (sneaking) {
                this.session.sendDownstreamGamePacket(new ServerboundPlayerCommandPacket(entity.javaId(), PlayerState.START_SNEAKING));
                this.session.startSneaking();
            } else {
                this.session.sendDownstreamGamePacket(new ServerboundPlayerCommandPacket(entity.javaId(), PlayerState.STOP_SNEAKING));
                this.session.stopSneaking();
            }
        }
        if (oldInputPacket != this.inputPacket) {
            this.session.sendDownstreamGamePacket(this.inputPacket);
        }
    }

    public boolean wasJumping() {
        return this.inputPacket.isJump();
    }

    public void markPositionPacketSent() {
        this.ticksSinceLastMovePacket = 0;
    }

    public boolean shouldSendPositionReminder() {
        return ++this.ticksSinceLastMovePacket >= 20;
    }

    public boolean lastHorizontalCollision() {
        return this.lastHorizontalCollision;
    }

    public void setLastHorizontalCollision(boolean lastHorizontalCollision) {
        this.lastHorizontalCollision = lastHorizontalCollision;
    }

    public int getJumpingTicks() {
        return this.jumpingTicks;
    }

    public void setJumpingTicks(int jumpingTicks) {
        this.jumpingTicks = jumpingTicks;
    }

    public float getJumpScale() {
        return this.jumpScale;
    }

    public void setJumpScale(float jumpScale) {
        this.jumpScale = jumpScale;
    }

    public @MonotonicNonNull InputMode getInputMode() {
        return this.inputMode;
    }

    public void setInputMode(@MonotonicNonNull InputMode inputMode) {
        this.inputMode = inputMode;
    }
}

