/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.nbt.NbtUtils;
import org.cloudburstmc.protocol.bedrock.codec.v766.Bedrock_v766;
import org.cloudburstmc.protocol.bedrock.codec.v776.Bedrock_v776;
import org.cloudburstmc.protocol.bedrock.codec.v786.Bedrock_v786;
import org.cloudburstmc.protocol.bedrock.codec.v800.Bedrock_v800;
import org.cloudburstmc.protocol.bedrock.data.BlockPropertyData;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBlockState;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.FlowerPotBlock;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.populator.CustomBlockRegistryPopulator;
import org.geysermc.geyser.registry.populator.conversion.Conversion776_766;
import org.geysermc.geyser.registry.populator.conversion.Conversion786_776;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;

public final class BlockRegistryPopulator {
    private static List<NbtMap> BLOCKS_NBT;
    public static int MIN_CUSTOM_RUNTIME_ID;
    public static int JAVA_BLOCKS_SIZE;
    private static final long FNV1_64_OFFSET_BASIS = -3750763034362895579L;
    private static final long FNV1_64_PRIME = 1099511628211L;

    public static void populate(Stage stage) {
        switch (stage) {
            case PRE_INIT: 
            case POST_INIT: {
                BlockRegistryPopulator.nullifyBlocksNbt();
                break;
            }
            case INIT_JAVA: {
                BlockRegistryPopulator.registerJavaBlocks();
                break;
            }
            case INIT_BEDROCK: {
                BlockRegistryPopulator.registerBedrockBlocks();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stage: " + String.valueOf((Object)stage));
            }
        }
    }

    private static void nullifyBlocksNbt() {
        BLOCKS_NBT = null;
    }

    private static void registerBedrockBlocks() {
        ImmutableMap blockMappers = ImmutableMap.builder().put(ObjectIntPair.of("1_21_50", Bedrock_v766.CODEC.getProtocolVersion()), Conversion776_766::remapBlock).put(ObjectIntPair.of("1_21_60", Bedrock_v776.CODEC.getProtocolVersion()), Conversion786_776::remapBlock).put(ObjectIntPair.of("1_21_70", Bedrock_v786.CODEC.getProtocolVersion()), tag -> tag).put(ObjectIntPair.of("1_21_80", Bedrock_v800.CODEC.getProtocolVersion()), tag -> tag).build();
        Interner statesInterner = Interners.newStrongInterner();
        for (ObjectIntPair palette : blockMappers.keySet()) {
            ArrayList<NbtMap> blockStates;
            ArrayList<NbtMap> vanillaBlockStates;
            int protocolVersion = palette.valueInt();
            try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(String.format("bedrock/block_palette.%s.nbt", palette.key()));
                 NBTInputStream nbtInputStream = new NBTInputStream(new DataInputStream(new GZIPInputStream(stream)), true, true);){
                NbtMap blockPalette = (NbtMap)nbtInputStream.readTag();
                vanillaBlockStates = new ArrayList<NbtMap>(blockPalette.getList("blocks", NbtType.COMPOUND));
                for (int i = 0; i < vanillaBlockStates.size(); ++i) {
                    CustomBlockData[] builder = ((NbtMap)vanillaBlockStates.get(i)).toBuilder();
                    builder.remove("version");
                    builder.remove("name_hash");
                    builder.remove("network_id");
                    builder.remove("block_id");
                    builder.putCompound("states", (NbtMap)statesInterner.intern((Object)((NbtMap)builder.remove("states"))));
                    vanillaBlockStates.set(i, builder.build());
                }
                blockStates = new ArrayList<NbtMap>(vanillaBlockStates);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to get blocks from runtime block states", e);
            }
            ArrayList<BlockPropertyData> customBlockProperties = new ArrayList<BlockPropertyData>();
            ArrayList<NbtMap> customBlockStates = new ArrayList<NbtMap>();
            ArrayList<CustomBlockState> customExtBlockStates = new ArrayList<CustomBlockState>();
            int[] remappedVanillaIds = new int[]{};
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                CustomBlockRegistryPopulator.BLOCK_ID.set(10000);
                for (CustomBlockData customBlock : (CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()) {
                    customBlockProperties.add(CustomBlockRegistryPopulator.generateBlockPropertyData(customBlock, protocolVersion));
                    CustomBlockRegistryPopulator.generateCustomBlockStates(customBlock, customBlockStates, customExtBlockStates);
                }
                blockStates.addAll(customBlockStates);
                GeyserImpl.getInstance().getLogger().debug("Added " + customBlockStates.size() + " custom block states to v" + protocolVersion + " palette.");
                blockStates.sort((a, b) -> Long.compareUnsigned(BlockRegistryPopulator.fnv164(a.getString("name")), BlockRegistryPopulator.fnv164(b.getString("name"))));
            }
            Object2ObjectOpenHashMap<NbtMap, GeyserBedrockBlock> blockStateOrderedMap = new Object2ObjectOpenHashMap<NbtMap, GeyserBedrockBlock>(blockStates.size());
            GeyserBedrockBlock[] bedrockRuntimeMap = new GeyserBedrockBlock[blockStates.size()];
            for (int i = 0; i < blockStates.size(); ++i) {
                GeyserBedrockBlock block2;
                NbtMap tag2 = (NbtMap)blockStates.get(i);
                if (blockStateOrderedMap.put(tag2, block2 = new GeyserBedrockBlock(i, tag2)) != null) {
                    throw new AssertionError((Object)("Duplicate block states in Bedrock palette: " + String.valueOf(tag2)));
                }
                bedrockRuntimeMap[i] = block2;
            }
            Object2ObjectMap<CustomBlockState, GeyserBedrockBlock> customBlockStateDefinitions = Object2ObjectMaps.emptyMap();
            Int2ObjectOpenHashMap<GeyserBedrockBlock> extendedCollisionBoxes = new Int2ObjectOpenHashMap<GeyserBedrockBlock>();
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                int i;
                customBlockStateDefinitions = new Object2ObjectOpenHashMap(customExtBlockStates.size());
                for (i = 0; i < customExtBlockStates.size(); ++i) {
                    NbtMap tag3 = (NbtMap)customBlockStates.get(i);
                    CustomBlockState blockState = (CustomBlockState)customExtBlockStates.get(i);
                    GeyserBedrockBlock bedrockBlock = (GeyserBedrockBlock)blockStateOrderedMap.get(tag3);
                    customBlockStateDefinitions.put(blockState, bedrockBlock);
                    Set extendedCollisionjavaIds = BlockRegistries.EXTENDED_COLLISION_BOXES.getOrDefault(blockState.block(), null);
                    if (extendedCollisionjavaIds == null) continue;
                    Iterator iterator = extendedCollisionjavaIds.iterator();
                    while (iterator.hasNext()) {
                        int javaId = (Integer)iterator.next();
                        extendedCollisionBoxes.put(javaId, bedrockBlock);
                    }
                }
                remappedVanillaIds = new int[vanillaBlockStates.size()];
                for (i = 0; i < vanillaBlockStates.size(); ++i) {
                    GeyserBedrockBlock bedrockBlock = (GeyserBedrockBlock)blockStateOrderedMap.get(vanillaBlockStates.get(i));
                    remappedVanillaIds[i] = bedrockBlock != null ? bedrockBlock.getRuntimeId() : -1;
                }
            }
            int javaRuntimeId = -1;
            List javaBlockStates = (List)BlockRegistries.BLOCK_STATES.get();
            GeyserBedrockBlock airDefinition = null;
            GeyserBedrockBlock commandBlockDefinition = null;
            GeyserBedrockBlock mobSpawnerBlockDefinition = null;
            GeyserBedrockBlock netherPortalBlockDefinition = null;
            GeyserBedrockBlock waterDefinition = null;
            GeyserBedrockBlock movingBlockDefinition = null;
            Iterator<NbtMap> blocksIterator = BLOCKS_NBT.iterator();
            Remapper stateMapper = (Remapper)blockMappers.get((Object)palette);
            Object[] javaToBedrockBlocks = new GeyserBedrockBlock[JAVA_BLOCKS_SIZE];
            Object[] javaToVanillaBedrockBlocks = new GeyserBedrockBlock[JAVA_BLOCKS_SIZE];
            Int2ObjectOpenHashMap<String> javaToBedrockIdentifiers = new Int2ObjectOpenHashMap<String>();
            Block lastBlockSeen = null;
            List javaPottable = ((List)BlockRegistries.JAVA_BLOCKS.get()).parallelStream().flatMap(block -> {
                FlowerPotBlock flowerPot;
                if (block instanceof FlowerPotBlock && (flowerPot = (FlowerPotBlock)block).flower() != Blocks.AIR) {
                    return Stream.of(flowerPot.flower());
                }
                return null;
            }).toList();
            Object2ObjectOpenHashMap<Block, NbtMap> flowerPotBlocks = new Object2ObjectOpenHashMap<Block, NbtMap>();
            Object2ObjectOpenHashMap<NbtMap, BlockDefinition> itemFrames = new Object2ObjectOpenHashMap<NbtMap, BlockDefinition>();
            ObjectOpenHashSet<BlockDefinition> jigsawDefinitions = new ObjectOpenHashSet<BlockDefinition>();
            Object2ObjectOpenHashMap<String, BlockDefinition> structureBlockDefinitions = new Object2ObjectOpenHashMap<String, BlockDefinition>();
            BlockMappings.BlockMappingsBuilder builder = BlockMappings.builder();
            while (blocksIterator.hasNext()) {
                boolean waterlogged;
                GeyserBedrockBlock bedrockDefinition;
                NbtMap entry2 = blocksIterator.next();
                BlockState blockState = (BlockState)javaBlockStates.get(++javaRuntimeId);
                String javaId = blockState.toString();
                NbtMap originalBedrockTag = BlockRegistryPopulator.buildBedrockState(blockState, entry2);
                NbtMap bedrockTag = stateMapper.remap(originalBedrockTag);
                GeyserBedrockBlock vanillaBedrockDefinition = (GeyserBedrockBlock)blockStateOrderedMap.get(bedrockTag);
                CustomBlockState blockStateOverride = (CustomBlockState)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get(javaRuntimeId);
                if (blockStateOverride == null) {
                    bedrockDefinition = vanillaBedrockDefinition;
                    if (bedrockDefinition == null) {
                        throw new RuntimeException("Unable to find %s Bedrock runtime ID for %s! Original block tag:\n%s\nUpdated block tag:\n%s".formatted(javaId, palette.key(), originalBedrockTag, bedrockTag));
                    }
                } else {
                    bedrockDefinition = (GeyserBedrockBlock)customBlockStateDefinitions.get(blockStateOverride);
                    if (bedrockDefinition == null) {
                        throw new RuntimeException("Unable to find " + javaId + " Bedrock runtime ID! Custom block override: \n" + String.valueOf(blockStateOverride));
                    }
                }
                switch (javaId) {
                    case "minecraft:air": {
                        airDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:water[level=0]": {
                        waterDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:command_block[conditional=false,facing=north]": {
                        commandBlockDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:spawner": {
                        mobSpawnerBlockDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:moving_piston[facing=north,type=normal]": {
                        movingBlockDefinition = bedrockDefinition;
                    }
                }
                Block block3 = blockState.block();
                if (block3 != lastBlockSeen) {
                    lastBlockSeen = block3;
                    String bedrockName = bedrockDefinition.getState().getString("name");
                    if (!block3.javaIdentifier().toString().equals(bedrockName)) {
                        javaToBedrockIdentifiers.put(block3.javaId(), bedrockName.substring("minecraft:".length()).intern());
                    }
                }
                if (block3 == Blocks.JIGSAW) {
                    jigsawDefinitions.add(bedrockDefinition);
                }
                if (block3 == Blocks.STRUCTURE_BLOCK) {
                    String mode = blockState.getValue(Properties.STRUCTUREBLOCK_MODE);
                    structureBlockDefinitions.put(mode.toUpperCase(Locale.ROOT), bedrockDefinition);
                }
                if (block3 == Blocks.NETHER_PORTAL) {
                    netherPortalBlockDefinition = bedrockDefinition;
                }
                boolean bl = waterlogged = blockState.getValue(Properties.WATERLOGGED, false) != false || block3 == Blocks.BUBBLE_COLUMN || block3 == Blocks.KELP || block3 == Blocks.KELP_PLANT || block3 == Blocks.SEAGRASS || block3 == Blocks.TALL_SEAGRASS;
                if (waterlogged) {
                    ((BitSet)BlockRegistries.WATERLOGGED.get()).set(javaRuntimeId);
                }
                if (javaPottable.contains(block3)) {
                    flowerPotBlocks.put(block3, (NbtMap)blockStates.get(bedrockDefinition.getRuntimeId()));
                }
                javaToVanillaBedrockBlocks[javaRuntimeId] = vanillaBedrockDefinition;
                javaToBedrockBlocks[javaRuntimeId] = bedrockDefinition;
            }
            if (commandBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find command block in palette");
            }
            builder.commandBlock(commandBlockDefinition);
            if (mobSpawnerBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find mob spawner block in palette");
            }
            builder.mobSpawnerBlock(mobSpawnerBlockDefinition);
            if (netherPortalBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find nether portal block in palette");
            }
            builder.netherPortalBlock(netherPortalBlockDefinition);
            if (waterDefinition == null) {
                throw new AssertionError((Object)"Unable to find water in palette");
            }
            builder.bedrockWater(waterDefinition);
            if (airDefinition == null) {
                throw new AssertionError((Object)"Unable to find air in palette");
            }
            builder.bedrockAir(airDefinition);
            if (movingBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find moving block in palette");
            }
            builder.bedrockMovingBlock(movingBlockDefinition);
            Map nonVanillaStateOverrides = (Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get();
            if (!nonVanillaStateOverrides.isEmpty()) {
                Arrays.fill(javaToVanillaBedrockBlocks, MIN_CUSTOM_RUNTIME_ID, javaToVanillaBedrockBlocks.length, airDefinition);
                Arrays.fill(javaToBedrockBlocks, MIN_CUSTOM_RUNTIME_ID, javaToBedrockBlocks.length, airDefinition);
                for (Map.Entry entry3 : nonVanillaStateOverrides.entrySet()) {
                    GeyserBedrockBlock bedrockDefinition = (GeyserBedrockBlock)customBlockStateDefinitions.get(entry3.getValue());
                    if (bedrockDefinition == null) {
                        GeyserImpl.getInstance().getLogger().warning("Unable to find custom block for " + String.valueOf(entry3.getValue()));
                        continue;
                    }
                    JavaBlockState javaState = (JavaBlockState)entry3.getKey();
                    int stateRuntimeId = javaState.javaId();
                    boolean waterlogged = javaState.waterlogged();
                    if (waterlogged) {
                        BlockRegistries.WATERLOGGED.register(set -> set.set(stateRuntimeId));
                    }
                    javaToVanillaBedrockBlocks[stateRuntimeId] = bedrockDefinition;
                    javaToBedrockBlocks[stateRuntimeId] = bedrockDefinition;
                    javaToBedrockIdentifiers.put(((JavaBlockState)entry3.getKey()).stateGroupId(), ((CustomBlockState)entry3.getValue()).block().identifier());
                }
            }
            javaToBedrockIdentifiers.trim();
            Object2ObjectMaps.fastForEach(blockStateOrderedMap, entry -> {
                String name = ((NbtMap)entry.getKey()).getString("name");
                if (name.equals("minecraft:frame") || name.equals("minecraft:glow_frame")) {
                    itemFrames.put((NbtMap)entry.getKey(), (BlockDefinition)entry.getValue());
                }
            });
            BlockRegistries.BLOCKS.register(palette.valueInt(), builder.bedrockRuntimeMap(bedrockRuntimeMap).javaToBedrockBlocks((GeyserBedrockBlock[])javaToBedrockBlocks).javaToVanillaBedrockBlocks((GeyserBedrockBlock[])javaToVanillaBedrockBlocks).javaToBedrockIdentifiers(javaToBedrockIdentifiers).stateDefinitionMap(blockStateOrderedMap).itemFrames(itemFrames).flowerPotBlocks(flowerPotBlocks).jigsawStates(jigsawDefinitions).structureBlockStates(structureBlockDefinitions).remappedVanillaIds(remappedVanillaIds).blockProperties(customBlockProperties).customBlockStateDefinitions(customBlockStateDefinitions).extendedCollisionBoxes(extendedCollisionBoxes).build());
        }
    }

    private static void registerJavaBlocks() {
        JsonNode blockInteractionsJson;
        List<NbtMap> blocksNbt;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/blocks.nbt");){
            blocksNbt = ((NbtMap)NbtUtils.createGZIPReader(stream).readTag()).getList("bedrock_mappings", NbtType.COMPOUND);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java block mappings", e);
        }
        int javaRuntimeId = -1;
        for (BlockState javaBlockState : (List)BlockRegistries.BLOCK_STATES.get()) {
            String javaId = javaBlockState.toString().intern();
            BlockRegistries.JAVA_IDENTIFIER_TO_ID.register(javaId, ++javaRuntimeId);
        }
        BLOCKS_NBT = blocksNbt;
        JAVA_BLOCKS_SIZE = blocksNbt.size();
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/interactions.json");){
            blockInteractionsJson = GeyserImpl.JSON_MAPPER.readTree(stream);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java block interaction mappings", e);
        }
        BlockRegistries.INTERACTIVE.set(BlockRegistryPopulator.toBlockStateSet((ArrayNode)blockInteractionsJson.get("always_consumes")));
        BlockRegistries.INTERACTIVE_MAY_BUILD.set(BlockRegistryPopulator.toBlockStateSet((ArrayNode)blockInteractionsJson.get("requires_may_build")));
    }

    private static BitSet toBlockStateSet(ArrayNode node) {
        BitSet blockStateSet = new BitSet(node.size());
        for (JsonNode javaIdentifier : node) {
            blockStateSet.set(((Object2IntMap)BlockRegistries.JAVA_IDENTIFIER_TO_ID.get()).getInt(javaIdentifier.textValue()));
        }
        return blockStateSet;
    }

    private static NbtMap buildBedrockState(BlockState state, NbtMap nbt) {
        NbtMapBuilder tagBuilder = NbtMap.builder();
        String bedrockIdentifier = "minecraft:" + nbt.getString("bedrock_identifier", state.block().javaIdentifier().value());
        tagBuilder.putString("name", bedrockIdentifier);
        tagBuilder.put("states", (Object)nbt.getCompound("state"));
        return tagBuilder.build();
    }

    private static long fnv164(String str) {
        long hash = -3750763034362895579L;
        for (byte b : str.getBytes(StandardCharsets.UTF_8)) {
            hash *= 1099511628211L;
            hash ^= (long)b;
        }
        return hash;
    }

    static {
        MIN_CUSTOM_RUNTIME_ID = -1;
        JAVA_BLOCKS_SIZE = -1;
    }

    public static enum Stage {
        PRE_INIT,
        INIT_JAVA,
        INIT_BEDROCK,
        POST_INIT;

    }

    @FunctionalInterface
    static interface Remapper {
        public NbtMap remap(NbtMap var1);
    }
}

