/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.registry.AbstractMappedRegistry;
import org.geysermc.geyser.registry.loader.RegistryLoader;

public class VersionedRegistry<V>
extends AbstractMappedRegistry<Integer, V, Int2ObjectMap<V>> {
    protected <I> VersionedRegistry(I input, RegistryLoader<I, Int2ObjectMap<V>> registryLoader) {
        super(input, registryLoader);
    }

    public @NonNull V forVersion(int version) {
        Map.Entry current = null;
        for (Int2ObjectMap.Entry entry : ((Int2ObjectMap)this.mappings).int2ObjectEntrySet()) {
            int currentVersion = entry.getIntKey();
            if (version < currentVersion) continue;
            if (version == currentVersion) {
                return entry.getValue();
            }
            if (current != null && current.getIntKey() >= currentVersion) continue;
            current = entry;
        }
        if (current == null) {
            throw new IllegalArgumentException("No appropriate value for version: " + version);
        }
        return current.getValue();
    }

    public static <I, V> VersionedRegistry<V> create(RegistryLoader<I, Int2ObjectMap<V>> registryLoader) {
        return new VersionedRegistry<V>(null, registryLoader);
    }

    public static <I, V> VersionedRegistry<V> create(I input, RegistryLoader<I, Int2ObjectMap<V>> registryLoader) {
        return new VersionedRegistry<V>(input, registryLoader);
    }

    public static <I, V> VersionedRegistry<V> create(Supplier<RegistryLoader<I, Int2ObjectMap<V>>> registryLoader) {
        return new VersionedRegistry<V>(null, registryLoader.get());
    }

    public static <I, V> VersionedRegistry<V> create(I input, Supplier<RegistryLoader<I, Int2ObjectMap<V>>> registryLoader) {
        return new VersionedRegistry<V>(input, registryLoader.get());
    }
}

