/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ServerboundSetJigsawBlockPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Vector3i position;
    @lombok.NonNull
    private final Key name;
    @lombok.NonNull
    private final Key target;
    @lombok.NonNull
    private final Key pool;
    @lombok.NonNull
    private final String finalState;
    @lombok.NonNull
    private final String jointType;
    private final int selectionPriority;
    private final int placementPriority;

    public ServerboundSetJigsawBlockPacket(ByteBuf in) {
        this.position = MinecraftTypes.readPosition(in);
        this.name = MinecraftTypes.readResourceLocation(in);
        this.target = MinecraftTypes.readResourceLocation(in);
        this.pool = MinecraftTypes.readResourceLocation(in);
        this.finalState = MinecraftTypes.readString(in);
        this.jointType = MinecraftTypes.readString(in);
        this.selectionPriority = MinecraftTypes.readVarInt(in);
        this.placementPriority = MinecraftTypes.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.position);
        MinecraftTypes.writeResourceLocation(out, this.name);
        MinecraftTypes.writeResourceLocation(out, this.target);
        MinecraftTypes.writeResourceLocation(out, this.pool);
        MinecraftTypes.writeString(out, this.finalState);
        MinecraftTypes.writeString(out, this.jointType);
        MinecraftTypes.writeVarInt(out, this.selectionPriority);
        MinecraftTypes.writeVarInt(out, this.placementPriority);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @lombok.NonNull
    public Key getName() {
        return this.name;
    }

    @lombok.NonNull
    public Key getTarget() {
        return this.target;
    }

    @lombok.NonNull
    public Key getPool() {
        return this.pool;
    }

    @lombok.NonNull
    public String getFinalState() {
        return this.finalState;
    }

    @lombok.NonNull
    public String getJointType() {
        return this.jointType;
    }

    public int getSelectionPriority() {
        return this.selectionPriority;
    }

    public int getPlacementPriority() {
        return this.placementPriority;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSetJigsawBlockPacket)) {
            return false;
        }
        ServerboundSetJigsawBlockPacket other = (ServerboundSetJigsawBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSelectionPriority() != other.getSelectionPriority()) {
            return false;
        }
        if (this.getPlacementPriority() != other.getPlacementPriority()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Key this$name = this.getName();
        Key other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Key this$target = this.getTarget();
        Key other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        Key this$pool = this.getPool();
        Key other$pool = other.getPool();
        if (this$pool == null ? other$pool != null : !this$pool.equals(other$pool)) {
            return false;
        }
        String this$finalState = this.getFinalState();
        String other$finalState = other.getFinalState();
        if (this$finalState == null ? other$finalState != null : !this$finalState.equals(other$finalState)) {
            return false;
        }
        String this$jointType = this.getJointType();
        String other$jointType = other.getJointType();
        return !(this$jointType == null ? other$jointType != null : !this$jointType.equals(other$jointType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSetJigsawBlockPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSelectionPriority();
        result = result * 59 + this.getPlacementPriority();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Key $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Key $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        Key $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : $pool.hashCode());
        String $finalState = this.getFinalState();
        result = result * 59 + ($finalState == null ? 43 : $finalState.hashCode());
        String $jointType = this.getJointType();
        result = result * 59 + ($jointType == null ? 43 : $jointType.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSetJigsawBlockPacket(position=" + String.valueOf(this.getPosition()) + ", name=" + String.valueOf(this.getName()) + ", target=" + String.valueOf(this.getTarget()) + ", pool=" + String.valueOf(this.getPool()) + ", finalState=" + this.getFinalState() + ", jointType=" + this.getJointType() + ", selectionPriority=" + this.getSelectionPriority() + ", placementPriority=" + this.getPlacementPriority() + ")";
    }

    public @NonNull ServerboundSetJigsawBlockPacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundSetJigsawBlockPacket(position, this.name, this.target, this.pool, this.finalState, this.jointType, this.selectionPriority, this.placementPriority);
    }

    public @NonNull ServerboundSetJigsawBlockPacket withName(@lombok.NonNull Key name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ServerboundSetJigsawBlockPacket(this.position, name, this.target, this.pool, this.finalState, this.jointType, this.selectionPriority, this.placementPriority);
    }

    public @NonNull ServerboundSetJigsawBlockPacket withTarget(@lombok.NonNull Key target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return this.target == target ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, target, this.pool, this.finalState, this.jointType, this.selectionPriority, this.placementPriority);
    }

    public @NonNull ServerboundSetJigsawBlockPacket withPool(@lombok.NonNull Key pool) {
        if (pool == null) {
            throw new NullPointerException("pool is marked non-null but is null");
        }
        return this.pool == pool ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, this.target, pool, this.finalState, this.jointType, this.selectionPriority, this.placementPriority);
    }

    public @NonNull ServerboundSetJigsawBlockPacket withFinalState(@lombok.NonNull String finalState) {
        if (finalState == null) {
            throw new NullPointerException("finalState is marked non-null but is null");
        }
        return this.finalState == finalState ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, this.target, this.pool, finalState, this.jointType, this.selectionPriority, this.placementPriority);
    }

    public @NonNull ServerboundSetJigsawBlockPacket withJointType(@lombok.NonNull String jointType) {
        if (jointType == null) {
            throw new NullPointerException("jointType is marked non-null but is null");
        }
        return this.jointType == jointType ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, this.target, this.pool, this.finalState, jointType, this.selectionPriority, this.placementPriority);
    }

    public @NonNull ServerboundSetJigsawBlockPacket withSelectionPriority(int selectionPriority) {
        return this.selectionPriority == selectionPriority ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, this.target, this.pool, this.finalState, this.jointType, selectionPriority, this.placementPriority);
    }

    public @NonNull ServerboundSetJigsawBlockPacket withPlacementPriority(int placementPriority) {
        return this.placementPriority == placementPriority ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, this.target, this.pool, this.finalState, this.jointType, this.selectionPriority, placementPriority);
    }

    public ServerboundSetJigsawBlockPacket(@lombok.NonNull Vector3i position, @lombok.NonNull Key name, @lombok.NonNull Key target, @lombok.NonNull Key pool, @lombok.NonNull String finalState, @lombok.NonNull String jointType, int selectionPriority, int placementPriority) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (pool == null) {
            throw new NullPointerException("pool is marked non-null but is null");
        }
        if (finalState == null) {
            throw new NullPointerException("finalState is marked non-null but is null");
        }
        if (jointType == null) {
            throw new NullPointerException("jointType is marked non-null but is null");
        }
        this.position = position;
        this.name = name;
        this.target = target;
        this.pool = pool;
        this.finalState = finalState;
        this.jointType = jointType;
        this.selectionPriority = selectionPriority;
        this.placementPriority = placementPriority;
    }
}

