/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.debug.DebugSubscriptions;

public class ServerboundDebugSubscriptionRequestPacket
implements MinecraftPacket {
    private final List<DebugSubscriptions> subscriptions;

    public ServerboundDebugSubscriptionRequestPacket(ByteBuf in) {
        this.subscriptions = new ArrayList<DebugSubscriptions>();
        int length = MinecraftTypes.readVarInt(in);
        for (int i = 0; i < length; ++i) {
            this.subscriptions.add(DebugSubscriptions.from(MinecraftTypes.readVarInt(in)));
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.subscriptions.size());
        for (DebugSubscriptions subscription : this.subscriptions) {
            MinecraftTypes.writeVarInt(out, subscription.ordinal());
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public List<DebugSubscriptions> getSubscriptions() {
        return this.subscriptions;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundDebugSubscriptionRequestPacket)) {
            return false;
        }
        ServerboundDebugSubscriptionRequestPacket other = (ServerboundDebugSubscriptionRequestPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<DebugSubscriptions> this$subscriptions = this.getSubscriptions();
        List<DebugSubscriptions> other$subscriptions = other.getSubscriptions();
        return !(this$subscriptions == null ? other$subscriptions != null : !((Object)this$subscriptions).equals(other$subscriptions));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundDebugSubscriptionRequestPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DebugSubscriptions> $subscriptions = this.getSubscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : ((Object)$subscriptions).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundDebugSubscriptionRequestPacket(subscriptions=" + String.valueOf(this.getSubscriptions()) + ")";
    }

    public @NonNull ServerboundDebugSubscriptionRequestPacket withSubscriptions(List<DebugSubscriptions> subscriptions) {
        return this.subscriptions == subscriptions ? this : new ServerboundDebugSubscriptionRequestPacket(subscriptions);
    }

    public ServerboundDebugSubscriptionRequestPacket(List<DebugSubscriptions> subscriptions) {
        this.subscriptions = subscriptions;
    }
}

