/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.DefaultComponentSerializer;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;

public class ClientboundOpenScreenPacket
implements MinecraftPacket {
    private final int containerId;
    @lombok.NonNull
    private final ContainerType type;
    @lombok.NonNull
    private final Component title;

    public ClientboundOpenScreenPacket(ByteBuf in) {
        this.containerId = MinecraftTypes.readVarInt(in);
        this.type = ContainerType.from(MinecraftTypes.readVarInt(in));
        this.title = MinecraftTypes.readComponent(in);
    }

    @Deprecated
    public ClientboundOpenScreenPacket(int containerId, @lombok.NonNull ContainerType type, @lombok.NonNull String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.containerId = containerId;
        this.type = type;
        this.title = DefaultComponentSerializer.get().deserialize(name);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.containerId);
        MinecraftTypes.writeVarInt(out, this.type.ordinal());
        MinecraftTypes.writeComponent(out, this.title);
    }

    @Deprecated
    public String getName() {
        return (String)DefaultComponentSerializer.get().serialize(this.title);
    }

    @Deprecated
    public ClientboundOpenScreenPacket withName(String name) {
        return new ClientboundOpenScreenPacket(this.containerId, this.type, (Component)DefaultComponentSerializer.get().deserialize(name));
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getContainerId() {
        return this.containerId;
    }

    @lombok.NonNull
    public ContainerType getType() {
        return this.type;
    }

    @lombok.NonNull
    public Component getTitle() {
        return this.title;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundOpenScreenPacket)) {
            return false;
        }
        ClientboundOpenScreenPacket other = (ClientboundOpenScreenPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        ContainerType this$type = this.getType();
        ContainerType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Component this$title = this.getTitle();
        Component other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundOpenScreenPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        ContainerType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Component $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundOpenScreenPacket(containerId=" + this.getContainerId() + ", type=" + String.valueOf((Object)this.getType()) + ", title=" + String.valueOf(this.getTitle()) + ")";
    }

    public @NonNull ClientboundOpenScreenPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundOpenScreenPacket(containerId, this.type, this.title);
    }

    public @NonNull ClientboundOpenScreenPacket withType(@lombok.NonNull ContainerType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ClientboundOpenScreenPacket(this.containerId, type, this.title);
    }

    public @NonNull ClientboundOpenScreenPacket withTitle(@lombok.NonNull Component title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        return this.title == title ? this : new ClientboundOpenScreenPacket(this.containerId, this.type, title);
    }

    public ClientboundOpenScreenPacket(int containerId, @lombok.NonNull ContainerType type, @lombok.NonNull Component title) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.containerId = containerId;
        this.type = type;
        this.title = title;
    }
}

