/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.common.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundUpdateTagsPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Map<Key, Map<Key, int[]>> tags = new HashMap<Key, Map<Key, int[]>>();

    public ClientboundUpdateTagsPacket(ByteBuf in) {
        int totalTagCount = MinecraftTypes.readVarInt(in);
        for (int i = 0; i < totalTagCount; ++i) {
            HashMap<Key, int[]> tag = new HashMap<Key, int[]>();
            Key tagName = MinecraftTypes.readResourceLocation(in);
            int tagsCount = MinecraftTypes.readVarInt(in);
            for (int j = 0; j < tagsCount; ++j) {
                Key name = MinecraftTypes.readResourceLocation(in);
                int entriesCount = MinecraftTypes.readVarInt(in);
                int[] entries = new int[entriesCount];
                for (int index = 0; index < entriesCount; ++index) {
                    entries[index] = MinecraftTypes.readVarInt(in);
                }
                tag.put(name, entries);
            }
            this.tags.put(tagName, tag);
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.tags.size());
        for (Map.Entry<Key, Map<Key, int[]>> tagSet : this.tags.entrySet()) {
            MinecraftTypes.writeResourceLocation(out, tagSet.getKey());
            MinecraftTypes.writeVarInt(out, tagSet.getValue().size());
            for (Map.Entry<Key, int[]> tag : tagSet.getValue().entrySet()) {
                MinecraftTypes.writeResourceLocation(out, tag.getKey());
                MinecraftTypes.writeVarInt(out, tag.getValue().length);
                for (int id : tag.getValue()) {
                    MinecraftTypes.writeVarInt(out, id);
                }
            }
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Map<Key, Map<Key, int[]>> getTags() {
        return this.tags;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateTagsPacket)) {
            return false;
        }
        ClientboundUpdateTagsPacket other = (ClientboundUpdateTagsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Key, Map<Key, int[]>> this$tags = this.getTags();
        Map<Key, Map<Key, int[]>> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundUpdateTagsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Key, Map<Key, int[]>> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundUpdateTagsPacket(tags=" + String.valueOf(this.getTags()) + ")";
    }

    public ClientboundUpdateTagsPacket() {
    }
}

