/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.common.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundResourcePackPushPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final UUID id;
    @lombok.NonNull
    private final String url;
    @lombok.NonNull
    private final String hash;
    private final boolean required;
    private final @Nullable Component prompt;

    public ClientboundResourcePackPushPacket(ByteBuf in) {
        this.id = MinecraftTypes.readUUID(in);
        this.url = MinecraftTypes.readString(in);
        this.hash = MinecraftTypes.readString(in);
        this.required = in.readBoolean();
        this.prompt = MinecraftTypes.readNullable(in, MinecraftTypes::readComponent);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeUUID(out, this.id);
        MinecraftTypes.writeString(out, this.url);
        MinecraftTypes.writeString(out, this.hash);
        out.writeBoolean(this.required);
        MinecraftTypes.writeNullable(out, this.prompt, MinecraftTypes::writeComponent);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public UUID getId() {
        return this.id;
    }

    @lombok.NonNull
    public String getUrl() {
        return this.url;
    }

    @lombok.NonNull
    public String getHash() {
        return this.hash;
    }

    public boolean isRequired() {
        return this.required;
    }

    public @Nullable Component getPrompt() {
        return this.prompt;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundResourcePackPushPacket)) {
            return false;
        }
        ClientboundResourcePackPushPacket other = (ClientboundResourcePackPushPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        Component this$prompt = this.getPrompt();
        Component other$prompt = other.getPrompt();
        return !(this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundResourcePackPushPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        Component $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundResourcePackPushPacket(id=" + String.valueOf(this.getId()) + ", url=" + this.getUrl() + ", hash=" + this.getHash() + ", required=" + this.isRequired() + ", prompt=" + String.valueOf(this.getPrompt()) + ")";
    }

    public @NonNull ClientboundResourcePackPushPacket withId(@lombok.NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.id == id ? this : new ClientboundResourcePackPushPacket(id, this.url, this.hash, this.required, this.prompt);
    }

    public @NonNull ClientboundResourcePackPushPacket withUrl(@lombok.NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.url == url ? this : new ClientboundResourcePackPushPacket(this.id, url, this.hash, this.required, this.prompt);
    }

    public @NonNull ClientboundResourcePackPushPacket withHash(@lombok.NonNull String hash) {
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        return this.hash == hash ? this : new ClientboundResourcePackPushPacket(this.id, this.url, hash, this.required, this.prompt);
    }

    public @NonNull ClientboundResourcePackPushPacket withRequired(boolean required) {
        return this.required == required ? this : new ClientboundResourcePackPushPacket(this.id, this.url, this.hash, required, this.prompt);
    }

    public @NonNull ClientboundResourcePackPushPacket withPrompt(@Nullable Component prompt) {
        return this.prompt == prompt ? this : new ClientboundResourcePackPushPacket(this.id, this.url, this.hash, this.required, prompt);
    }

    public ClientboundResourcePackPushPacket(@lombok.NonNull UUID id, @lombok.NonNull String url, @lombok.NonNull String hash, boolean required, @Nullable Component prompt) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        this.id = id;
        this.url = url;
        this.hash = hash;
        this.required = required;
        this.prompt = prompt;
    }
}

