/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;

public record TooltipDisplay(boolean hideTooltip, List<DataComponentType<?>> hiddenComponents) {
    public TooltipDisplay(boolean hideTooltip, List<DataComponentType<?>> hiddenComponents) {
        this.hideTooltip = hideTooltip;
        this.hiddenComponents = List.copyOf(hiddenComponents);
    }

    public static @NonNull TooltipDisplayBuilder builder() {
        return new TooltipDisplayBuilder();
    }

    public @NonNull TooltipDisplayBuilder toBuilder() {
        return new TooltipDisplayBuilder().hideTooltip(this.hideTooltip).hiddenComponents(this.hiddenComponents);
    }

    public static class TooltipDisplayBuilder {
        private boolean hideTooltip;
        private List<DataComponentType<?>> hiddenComponents;

        TooltipDisplayBuilder() {
        }

        public @NonNull TooltipDisplayBuilder hideTooltip(boolean hideTooltip) {
            this.hideTooltip = hideTooltip;
            return this;
        }

        public @NonNull TooltipDisplayBuilder hiddenComponents(List<DataComponentType<?>> hiddenComponents) {
            this.hiddenComponents = hiddenComponents;
            return this;
        }

        public @NonNull TooltipDisplay build() {
            return new TooltipDisplay(this.hideTooltip, this.hiddenComponents);
        }

        public @NonNull String toString() {
            return "TooltipDisplay.TooltipDisplayBuilder(hideTooltip=" + this.hideTooltip + ", hiddenComponents=" + String.valueOf(this.hiddenComponents) + ")";
        }
    }
}

