/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.RecipeUnlockingRequirement;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapedRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.SmithingTransformRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.DefaultDescriptor;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptor;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemTagDescriptor;
import org.cloudburstmc.protocol.bedrock.packet.CraftingDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.UnlockedRecipesPacket;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapelessRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserSmithingRecipe;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.BedrockRequiresTagItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.Pair;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.IntComparators;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.RecipeDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.RecipeDisplayEntry;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.ShapedCraftingRecipeDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.ShapelessCraftingRecipeDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.SmithingRecipeDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.CompositeSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.EmptySlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.ItemSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.ItemStackSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.SlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.SmithingTrimDemoSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.TagSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.WithRemainderSlotDisplay;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundRecipeBookAddPacket;

@Translator(packet=ClientboundRecipeBookAddPacket.class)
public class JavaRecipeBookAddTranslator
extends PacketTranslator<ClientboundRecipeBookAddPacket> {
    private static final ThreadLocal<Map<int[], List<ItemDescriptorWithCount>>> TAG_TO_ITEM_DESCRIPTOR_CACHE = ThreadLocal.withInitial(Object2ObjectOpenHashMap::new);

    @Override
    public void translate(GeyserSession session, ClientboundRecipeBookAddPacket packet) {
        int netId = session.getLastRecipeNetId().get();
        Int2ObjectMap<List<String>> javaToBedrockRecipeIds = session.getJavaToBedrockRecipeIds();
        Int2ObjectMap<GeyserRecipe> geyserRecipes = session.getCraftingRecipes();
        CraftingDataPacket craftingDataPacket = new CraftingDataPacket();
        UnlockedRecipesPacket recipesPacket = new UnlockedRecipesPacket();
        recipesPacket.setAction(packet.isReplace() ? UnlockedRecipesPacket.ActionType.INITIALLY_UNLOCKED : UnlockedRecipesPacket.ActionType.NEWLY_UNLOCKED);
        for (ClientboundRecipeBookAddPacket.Entry entry : packet.getEntries()) {
            RecipeDisplayEntry contents = entry.contents();
            RecipeDisplay display = contents.display();
            switch (display.getType()) {
                case CRAFTING_SHAPED: {
                    int recipeNetworkId;
                    String recipeId;
                    List<ItemDescriptorWithCount> inputs;
                    ShapedCraftingRecipeDisplay shapedRecipe = (ShapedCraftingRecipeDisplay)display;
                    Pair<List<List<ItemDescriptorWithCount>>, ItemData> bedrockRecipes = this.combinations(session, display, shapedRecipe.ingredients());
                    if (bedrockRecipes == null) break;
                    ArrayList<CallSite> bedrockRecipeIds = new ArrayList<CallSite>();
                    ItemData output = bedrockRecipes.right();
                    List<List<ItemDescriptorWithCount>> left = bedrockRecipes.left();
                    GeyserShapedRecipe geyserRecipe = new GeyserShapedRecipe(shapedRecipe);
                    for (int i = 0; i < left.size(); ++i) {
                        inputs = left.get(i);
                        recipeId = contents.id() + "_" + i;
                        recipeNetworkId = netId++;
                        craftingDataPacket.getCraftingData().add(ShapedRecipeData.shaped(recipeId, shapedRecipe.width(), shapedRecipe.height(), inputs, Collections.singletonList(output), UUID.randomUUID(), "crafting_table", 0, recipeNetworkId, false, RecipeUnlockingRequirement.INVALID));
                        recipesPacket.getUnlockedRecipes().add(recipeId);
                        bedrockRecipeIds.add((CallSite)((Object)recipeId));
                        geyserRecipes.put(recipeNetworkId, (GeyserRecipe)geyserRecipe);
                    }
                    javaToBedrockRecipeIds.put(contents.id(), (List<String>)List.copyOf(bedrockRecipeIds));
                    break;
                }
                case CRAFTING_SHAPELESS: {
                    int recipeNetworkId;
                    String recipeId;
                    List<ItemDescriptorWithCount> inputs;
                    ShapelessCraftingRecipeDisplay shapelessRecipe = (ShapelessCraftingRecipeDisplay)display;
                    Pair<List<List<ItemDescriptorWithCount>>, ItemData> bedrockRecipes = this.combinations(session, display, shapelessRecipe.ingredients());
                    if (bedrockRecipes == null) break;
                    ArrayList<CallSite> bedrockRecipeIds = new ArrayList();
                    ItemData output = bedrockRecipes.right();
                    List<List<ItemDescriptorWithCount>> left = bedrockRecipes.left();
                    GeyserShapelessRecipe geyserRecipe = new GeyserShapelessRecipe(shapelessRecipe);
                    for (int i = 0; i < left.size(); ++i) {
                        inputs = left.get(i);
                        recipeId = contents.id() + "_" + i;
                        recipeNetworkId = netId++;
                        craftingDataPacket.getCraftingData().add(ShapelessRecipeData.shapeless(recipeId, inputs, Collections.singletonList(output), UUID.randomUUID(), "crafting_table", 0, recipeNetworkId, RecipeUnlockingRequirement.INVALID));
                        recipesPacket.getUnlockedRecipes().add(recipeId);
                        bedrockRecipeIds.add((CallSite)((Object)recipeId));
                        geyserRecipes.put(recipeNetworkId, (GeyserRecipe)geyserRecipe);
                    }
                    javaToBedrockRecipeIds.put(contents.id(), (List<String>)List.copyOf(bedrockRecipeIds));
                    break;
                }
                case SMITHING: {
                    SmithingRecipeDisplay smithingRecipe;
                    Pair<Item, ItemData> output;
                    if (display.result() instanceof SmithingTrimDemoSlotDisplay || (output = this.translateToOutput(session, (smithingRecipe = (SmithingRecipeDisplay)display).result())) == null) break;
                    List<ItemDescriptorWithCount> bases = this.translateToInput(session, smithingRecipe.base());
                    List<ItemDescriptorWithCount> templates = this.translateToInput(session, smithingRecipe.template());
                    List<ItemDescriptorWithCount> additions = this.translateToInput(session, smithingRecipe.addition());
                    if (bases == null || templates == null || additions == null) break;
                    int i = 0;
                    ArrayList<CallSite> bedrockRecipeIds = new ArrayList<CallSite>();
                    for (ItemDescriptorWithCount template : templates) {
                        for (ItemDescriptorWithCount base : bases) {
                            for (ItemDescriptorWithCount addition : additions) {
                                String id = contents.id() + "_" + i++;
                                craftingDataPacket.getCraftingData().add(SmithingTransformRecipeData.of(id, template, base, addition, output.right(), "smithing_table", netId++));
                                recipesPacket.getUnlockedRecipes().add(id);
                                bedrockRecipeIds.add((CallSite)((Object)id));
                            }
                        }
                    }
                    javaToBedrockRecipeIds.put(contents.id(), (List<String>)bedrockRecipeIds);
                    session.getSmithingRecipes().add(new GeyserSmithingRecipe(smithingRecipe));
                }
            }
        }
        if (!recipesPacket.getUnlockedRecipes().isEmpty()) {
            session.sendUpstreamPacket(craftingDataPacket);
            session.sendUpstreamPacket(recipesPacket);
        }
        session.getLastRecipeNetId().set(netId);
        TAG_TO_ITEM_DESCRIPTOR_CACHE.remove();
    }

    private List<ItemDescriptorWithCount> translateToInput(GeyserSession session, SlotDisplay slotDisplay) {
        if (slotDisplay instanceof EmptySlotDisplay) {
            return Collections.singletonList(ItemDescriptorWithCount.EMPTY);
        }
        if (slotDisplay instanceof CompositeSlotDisplay) {
            CompositeSlotDisplay composite = (CompositeSlotDisplay)slotDisplay;
            if (composite.contents().size() == 1) {
                return this.translateToInput(session, composite.contents().get(0));
            }
            int[] items = new int[composite.contents().size()];
            List<SlotDisplay> contents = composite.contents();
            for (int i = 0; i < contents.size(); ++i) {
                int id;
                SlotDisplay subDisplay = contents.get(i);
                if (subDisplay instanceof ItemSlotDisplay) {
                    ItemSlotDisplay item = (ItemSlotDisplay)subDisplay;
                    id = item.item();
                } else if (!(subDisplay instanceof ItemStackSlotDisplay)) {
                    id = -1;
                } else {
                    ItemStackSlotDisplay itemStackSlotDisplay = (ItemStackSlotDisplay)subDisplay;
                    id = itemStackSlotDisplay.itemStack().getAmount() == 1 && itemStackSlotDisplay.itemStack().getDataComponentsPatch() == null ? itemStackSlotDisplay.itemStack().getId() : -1;
                }
                if (id == -1) {
                    return this.fallbackCompositeMapping(session, composite);
                }
                items[i] = id;
            }
            Arrays.sort(items);
            List<ItemDescriptorWithCount> tagDescriptor = this.lookupBedrockTag(session, items);
            if (tagDescriptor != null) {
                return tagDescriptor;
            }
            return this.fallbackCompositeMapping(session, composite);
        }
        if (slotDisplay instanceof WithRemainderSlotDisplay) {
            WithRemainderSlotDisplay remainder = (WithRemainderSlotDisplay)slotDisplay;
            return this.translateToInput(session, remainder.input());
        }
        if (slotDisplay instanceof ItemSlotDisplay) {
            ItemSlotDisplay itemSlot = (ItemSlotDisplay)slotDisplay;
            return Collections.singletonList(this.fromItem(session, itemSlot.item()));
        }
        if (slotDisplay instanceof ItemStackSlotDisplay) {
            ItemStackSlotDisplay itemStackSlot = (ItemStackSlotDisplay)slotDisplay;
            ItemData item = ItemTranslator.translateToBedrock(session, itemStackSlot.itemStack());
            return Collections.singletonList(ItemDescriptorWithCount.fromItem(item));
        }
        if (slotDisplay instanceof TagSlotDisplay) {
            TagSlotDisplay tagSlot = (TagSlotDisplay)slotDisplay;
            Key tag = tagSlot.tag();
            int[] items = session.getTagCache().getRaw(new Tag<Item>(JavaRegistries.ITEM, tag));
            if (items == null || items.length == 0) {
                return Collections.singletonList(ItemDescriptorWithCount.EMPTY);
            }
            if (items.length == 1) {
                return Collections.singletonList(this.fromItem(session, items[0]));
            }
            return TAG_TO_ITEM_DESCRIPTOR_CACHE.get().computeIfAbsent(items, key -> {
                List<ItemDescriptorWithCount> tagDescriptor = this.lookupBedrockTag(session, (int[])key);
                if (tagDescriptor != null) {
                    return tagDescriptor;
                }
                HashSet<ItemDescriptorWithCount> itemDescriptors = new HashSet<ItemDescriptorWithCount>();
                for (int item : key) {
                    itemDescriptors.add(this.fromItem(session, item));
                }
                return List.copyOf(itemDescriptors);
            });
        }
        session.getGeyser().getLogger().warning("Unimplemented slot display type for input: " + String.valueOf(slotDisplay));
        return null;
    }

    private Pair<Item, ItemData> translateToOutput(GeyserSession session, SlotDisplay slotDisplay) {
        if (slotDisplay instanceof EmptySlotDisplay) {
            return null;
        }
        if (slotDisplay instanceof ItemSlotDisplay) {
            ItemSlotDisplay itemSlot = (ItemSlotDisplay)slotDisplay;
            int item = itemSlot.item();
            return Pair.of(Registries.JAVA_ITEMS.get(item), ItemTranslator.translateToBedrock(session, new ItemStack(item)));
        }
        if (slotDisplay instanceof ItemStackSlotDisplay) {
            ItemStackSlotDisplay itemStackSlot = (ItemStackSlotDisplay)slotDisplay;
            ItemStack stack = itemStackSlot.itemStack();
            return Pair.of(Registries.JAVA_ITEMS.get(stack.getId()), ItemTranslator.translateToBedrock(session, stack));
        }
        session.getGeyser().getLogger().warning("Unimplemented slot display type for output: " + String.valueOf(slotDisplay));
        return null;
    }

    private ItemDescriptorWithCount fromItem(GeyserSession session, int item) {
        if (item == Items.AIR_ID) {
            return ItemDescriptorWithCount.EMPTY;
        }
        ItemMapping mapping = session.getItemMappings().getMapping(item);
        return new ItemDescriptorWithCount(new DefaultDescriptor(mapping.getBedrockDefinition(), mapping.getBedrockData()), 1);
    }

    private @Nullable List<ItemDescriptorWithCount> lookupBedrockTag(GeyserSession session, int[] items) {
        Object2ObjectMap<int[], String> bedrockTags = Registries.TAGS.forVersion(session.getUpstream().getProtocolVersion());
        String bedrockTag = (String)bedrockTags.get(items);
        if (bedrockTag != null) {
            return Collections.singletonList(new ItemDescriptorWithCount(new ItemTagDescriptor(bedrockTag), 1));
        }
        return null;
    }

    private List<ItemDescriptorWithCount> fallbackCompositeMapping(GeyserSession session, CompositeSlotDisplay composite) {
        return composite.contents().stream().map(subDisplay -> this.translateToInput(session, (SlotDisplay)subDisplay)).filter(Objects::nonNull).flatMap(Collection::stream).toList();
    }

    private Pair<List<List<ItemDescriptorWithCount>>, ItemData> combinations(GeyserSession session, RecipeDisplay display, List<SlotDisplay> ingredients) {
        Pair<Item, ItemData> pair = this.translateToOutput(session, display.result());
        if (pair == null || !pair.right().isValid()) {
            return null;
        }
        ItemData output = pair.right();
        if (!(pair.left() instanceof BedrockRequiresTagItem)) {
            output = output.toBuilder().tag(null).build();
        }
        boolean empty = true;
        boolean complexInputs = false;
        List<Object> inputs = new ArrayList<Object>(ingredients.size());
        for (SlotDisplay input : ingredients) {
            List<ItemDescriptorWithCount> translated = this.translateToInput(session, input);
            if (translated == null) continue;
            inputs.add(translated);
            if (translated.size() != 1 || translated.get(0) != ItemDescriptorWithCount.EMPTY) {
                empty = false;
            }
            complexInputs |= translated.size() > 1;
        }
        if (empty) {
            return null;
        }
        if (complexInputs) {
            long size = 1L;
            for (List list : inputs) {
                if ((size *= (long)list.size()) <= 500L) continue;
                complexInputs = false;
                break;
            }
            if (complexInputs) {
                return Pair.of(Lists.cartesianProduct(inputs), output);
            }
        }
        int totalSimpleRecipes = inputs.stream().mapToInt(List::size).max().orElse(1);
        inputs = inputs.stream().map(descriptors -> descriptors.stream().sorted(ItemDescriptorWithCountComparator.INSTANCE).collect(Collectors.toList())).collect(Collectors.toList());
        ArrayList<List<ItemDescriptorWithCount>> finalRecipes = new ArrayList<List<ItemDescriptorWithCount>>(totalSimpleRecipes);
        int i = 0;
        while (i < totalSimpleRecipes) {
            int n = i++;
            finalRecipes.add(inputs.stream().map(descriptors -> {
                if (descriptors.size() > current) {
                    return (ItemDescriptorWithCount)descriptors.get(current);
                }
                return (ItemDescriptorWithCount)descriptors.get(0);
            }).toList());
        }
        return Pair.of(finalRecipes, output);
    }

    static class ItemDescriptorWithCountComparator
    implements Comparator<ItemDescriptorWithCount> {
        static ItemDescriptorWithCountComparator INSTANCE = new ItemDescriptorWithCountComparator();

        ItemDescriptorWithCountComparator() {
        }

        @Override
        public int compare(ItemDescriptorWithCount o1, ItemDescriptorWithCount o2) {
            ItemTagDescriptor itemTagDescriptor;
            String tag1 = null;
            String tag2 = null;
            ItemDescriptor itemDescriptor = o1.getDescriptor();
            if (itemDescriptor instanceof ItemTagDescriptor) {
                itemTagDescriptor = (ItemTagDescriptor)itemDescriptor;
                tag1 = itemTagDescriptor.getItemTag();
            }
            if ((itemDescriptor = o2.getDescriptor()) instanceof ItemTagDescriptor) {
                itemTagDescriptor = (ItemTagDescriptor)itemDescriptor;
                tag2 = itemTagDescriptor.getItemTag();
            }
            if (tag1 != null || tag2 != null) {
                if (tag1 != null && tag2 != null) {
                    return tag1.compareTo(tag2);
                }
                if (tag1 != null) {
                    return -1;
                }
                return 1;
            }
            ItemDescriptor itemDescriptor2 = o1.getDescriptor();
            if (itemDescriptor2 instanceof DefaultDescriptor) {
                DefaultDescriptor defaultDescriptor1 = (DefaultDescriptor)itemDescriptor2;
                itemDescriptor2 = o2.getDescriptor();
                if (itemDescriptor2 instanceof DefaultDescriptor) {
                    DefaultDescriptor defaultDescriptor2 = (DefaultDescriptor)itemDescriptor2;
                    return IntComparators.NATURAL_COMPARATOR.compare(defaultDescriptor1.getItemId().getRuntimeId(), defaultDescriptor2.getItemId().getRuntimeId());
                }
            }
            throw new IllegalStateException("Unable to compare unknown item descriptors: " + String.valueOf(o1) + " and " + String.valueOf(o2));
        }
    }
}

