/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.cumulus.response.FormResponse;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.session.dialog.ConfirmationDialog;
import org.geysermc.geyser.session.dialog.DialogButton;
import org.geysermc.geyser.session.dialog.DialogHolder;
import org.geysermc.geyser.session.dialog.DialogListDialog;
import org.geysermc.geyser.session.dialog.MultiActionDialog;
import org.geysermc.geyser.session.dialog.NoticeDialog;
import org.geysermc.geyser.session.dialog.ServerLinksDialog;
import org.geysermc.geyser.session.dialog.input.DialogInput;
import org.geysermc.geyser.session.dialog.input.ParsedInputs;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;

public abstract class Dialog {
    private static final Key PLAIN_MESSAGE_BODY = MinecraftKey.key("plain_message");
    private final String title;
    private final Optional<String> externalTitle;
    private final boolean canCloseWithEscape;
    private final AfterAction afterAction;
    private final List<String> labels;
    private final List<DialogInput<?>> inputs = new ArrayList();
    private final ParsedInputs defaultInputs;

    protected Dialog(Optional<GeyserSession> session, NbtMap map) {
        this.title = MessageTranslator.convertFromNullableNbtTag(session, map.get("title"));
        this.externalTitle = Optional.ofNullable(MessageTranslator.convertFromNullableNbtTag(session, map.get("external_title")));
        this.canCloseWithEscape = map.getBoolean("can_close_with_escape", true);
        this.afterAction = AfterAction.fromString(map.getString("after_action"));
        Object bodyTag = map.get("body");
        if (bodyTag == null) {
            this.labels = List.of();
        } else if (bodyTag instanceof NbtMap) {
            NbtMap bodyMap = (NbtMap)bodyTag;
            this.labels = Dialog.readBody(session, bodyMap).map(List::of).orElse(List.of());
        } else if (bodyTag instanceof List) {
            List bodyList = (List)bodyTag;
            this.labels = new ArrayList<String>();
            for (NbtMap tag : bodyList) {
                if (tag instanceof NbtMap) {
                    NbtMap bodyMap = tag;
                    Dialog.readBody(session, bodyMap).ifPresent(this.labels::add);
                    continue;
                }
                throw new IllegalStateException("Found non-NBT map in list of bodies, was: " + String.valueOf(tag));
            }
        } else {
            throw new IllegalStateException("Expected body tag to either be a NBT map or list thereof, was: " + String.valueOf(bodyTag));
        }
        List<NbtMap> inputTag = map.getList("inputs", NbtType.COMPOUND);
        for (NbtMap input : inputTag) {
            this.inputs.add(DialogInput.read(session, input));
        }
        this.defaultInputs = this.inputs.isEmpty() ? ParsedInputs.EMPTY : new ParsedInputs(this.inputs);
    }

    private static Optional<String> readBody(Optional<GeyserSession> session, NbtMap tag) {
        Key type = MinecraftKey.key(tag.getString("type"));
        if (type.equals(PLAIN_MESSAGE_BODY)) {
            return Optional.ofNullable(MessageTranslator.convertFromNullableNbtTag(session, tag.get("contents")));
        }
        return Optional.empty();
    }

    protected abstract Optional<DialogButton> onCancel();

    protected FormBuilder<? extends FormBuilder<?, ?, ?>, ? extends Form, ? extends FormResponse> createForm(DialogHolder holder, Optional<ParsedInputs> restored) {
        if (this.inputs.isEmpty()) {
            SimpleForm.Builder builder = (SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().translator(MinecraftLocale::getLocaleString, holder.session().locale())).title(this.title);
            builder.content(String.join((CharSequence)"\n\n", this.labels));
            builder.closedOrInvalidResultHandler(() -> holder.closeDialog(this.onCancel()));
            this.addCustomComponents(holder, builder);
            return builder;
        }
        CustomForm.Builder builder = (CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().translator(MinecraftLocale::getLocaleString, holder.session().locale())).title(this.title);
        for (String label : this.labels) {
            builder.label(label);
        }
        restored.ifPresentOrElse(last -> last.restore(holder, builder), () -> this.inputs.forEach(input -> input.addComponent(builder)));
        builder.closedOrInvalidResultHandler(response -> holder.closeDialog(this.onCancel()));
        this.addCustomComponents(holder, builder);
        return builder;
    }

    protected abstract void addCustomComponents(DialogHolder var1, CustomForm.Builder var2);

    protected abstract void addCustomComponents(DialogHolder var1, SimpleForm.Builder var2);

    public void sendForm(DialogHolder holder) {
        holder.session().sendDialogForm(this.createForm(holder, Optional.empty()).build());
    }

    public void restoreForm(DialogHolder holder, @NonNull ParsedInputs inputs) {
        holder.session().sendDialogForm(this.createForm(holder, Optional.of(inputs)).build());
    }

    protected Optional<ParsedInputs> parseInput(DialogHolder holder, CustomFormResponse response) {
        ParsedInputs parsed = new ParsedInputs(this.inputs, response);
        if (parsed.hasErrors()) {
            this.restoreForm(holder, parsed);
            return Optional.empty();
        }
        return Optional.of(parsed);
    }

    public static Dialog readDialog(RegistryEntryContext context) {
        return Dialog.readDialogFromNbt(context.session(), context.data(), context::getNetworkId);
    }

    public static Dialog readDialogFromNbt(Optional<GeyserSession> session, NbtMap map, IdGetter idGetter) {
        Key type = MinecraftKey.key(map.getString("type"));
        if (type.equals(NoticeDialog.TYPE)) {
            return new NoticeDialog(session, map, idGetter);
        }
        if (type.equals(ServerLinksDialog.TYPE)) {
            return new ServerLinksDialog(session, map, idGetter);
        }
        if (type.equals(DialogListDialog.TYPE)) {
            return new DialogListDialog(session, map, idGetter);
        }
        if (type.equals(MultiActionDialog.TYPE)) {
            return new MultiActionDialog(session, map, idGetter);
        }
        if (type.equals(ConfirmationDialog.TYPE)) {
            return new ConfirmationDialog(session, map, idGetter);
        }
        throw new UnsupportedOperationException("Unable to read unknown dialog type " + String.valueOf(type) + "!");
    }

    public static Dialog getDialogFromHolder(GeyserSession session, Holder<NbtMap> holder) {
        if (holder.isId()) {
            return Objects.requireNonNull(JavaRegistries.DIALOG.value(session, holder.id()));
        }
        return Dialog.readDialogFromNbt(Optional.of(session), holder.custom(), key -> JavaRegistries.DIALOG.networkId(session, (Key)key));
    }

    public static Dialog getDialogFromKey(GeyserSession session, Key key) {
        return Objects.requireNonNull(JavaRegistries.DIALOG.value(session, key));
    }

    public String title() {
        return this.title;
    }

    public Optional<String> externalTitle() {
        return this.externalTitle;
    }

    public boolean canCloseWithEscape() {
        return this.canCloseWithEscape;
    }

    public AfterAction afterAction() {
        return this.afterAction;
    }

    public ParsedInputs defaultInputs() {
        return this.defaultInputs;
    }

    public static enum AfterAction {
        CLOSE,
        NONE,
        WAIT_FOR_RESPONSE;


        public static AfterAction fromString(String string) {
            for (AfterAction action : AfterAction.values()) {
                if (!action.name().toLowerCase(Locale.ROOT).equals(string)) continue;
                return action;
            }
            return CLOSE;
        }
    }

    @FunctionalInterface
    public static interface IdGetter
    extends ToIntFunction<Key> {
    }
}

