/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.List;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.chunk.GeyserChunk;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.DataPalette;

public class ChunkCache {
    private final boolean cache;
    private final Long2ObjectMap<GeyserChunk> chunks;
    private int minY;
    private int heightY;

    public ChunkCache(GeyserSession session) {
        this.cache = !session.getGeyser().getWorldManager().hasOwnChunkCache();
        this.chunks = this.cache ? new Long2ObjectOpenHashMap() : null;
    }

    public void addToCache(int x, int z, DataPalette[] chunks) {
        if (!this.cache) {
            return;
        }
        long chunkPosition = MathUtils.chunkPositionToLong(x, z);
        GeyserChunk geyserChunk = GeyserChunk.from(chunks);
        this.chunks.put(chunkPosition, geyserChunk);
    }

    private GeyserChunk getChunk(int chunkX, int chunkZ) {
        long chunkPosition = MathUtils.chunkPositionToLong(chunkX, chunkZ);
        return this.chunks.getOrDefault(chunkPosition, (GeyserChunk)null);
    }

    public void updateBlock(int x, int y, int z, int block) {
        if (!this.cache) {
            return;
        }
        GeyserChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk == null) {
            return;
        }
        if (y < this.minY || y - this.minY >> 4 > chunk.sections().length - 1) {
            return;
        }
        boolean previouslyEmpty = false;
        try {
            DataPalette palette = chunk.sections()[y - this.minY >> 4];
            if (palette == null) {
                previouslyEmpty = true;
                if (block != 0) {
                    chunk.sections()[y - this.minY >> 4] = palette = DataPalette.createForBlockState(0, ((List)BlockRegistries.BLOCK_STATES.get()).size());
                } else {
                    return;
                }
            }
            palette.set(x & 0xF, y & 0xF, z & 0xF, block);
        }
        catch (Throwable e) {
            GeyserImpl.getInstance().getLogger().error("Failed to update block in chunk cache! ", e);
            GeyserImpl.getInstance().getLogger().error("Info: newChunk=%s, block=%s, pos=%s,%s,%s".formatted(previouslyEmpty, block, x, y, z));
        }
    }

    public int getBlockAt(int x, int y, int z) {
        if (!this.cache) {
            return 0;
        }
        GeyserChunk column = this.getChunk(x >> 4, z >> 4);
        if (column == null) {
            return 0;
        }
        if (y < this.minY || y - this.minY >> 4 > column.sections().length - 1) {
            return 0;
        }
        DataPalette chunk = column.sections()[y - this.minY >> 4];
        if (chunk != null) {
            return chunk.get(x & 0xF, y & 0xF, z & 0xF);
        }
        return 0;
    }

    public void removeChunk(int chunkX, int chunkZ) {
        if (!this.cache) {
            return;
        }
        long chunkPosition = MathUtils.chunkPositionToLong(chunkX, chunkZ);
        this.chunks.remove(chunkPosition);
    }

    public void clear() {
        if (!this.cache) {
            return;
        }
        this.chunks.clear();
    }

    public int getChunkMinY() {
        return this.minY >> 4;
    }

    public int getChunkHeightY() {
        return this.heightY >> 4;
    }

    public void setMinY(int minY) {
        this.minY = minY;
    }

    public void setHeightY(int heightY) {
        this.heightY = heightY;
    }
}

