/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.type;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemGroup;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.common.DefinitionRegistry;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.StoredItemMappings;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.IntSet;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public final class ItemMappings
implements DefinitionRegistry<ItemDefinition> {
    private final Map<String, ItemMapping> cachedJavaMappings = new WeakHashMap<String, ItemMapping>();
    private final ItemMapping[] items;
    private final ItemMapping lodestoneCompass;
    private final Int2ObjectMap<ItemMapping> lightBlocks;
    private final List<CreativeItemGroup> creativeItemGroups;
    private final List<CreativeItemData> creativeItems;
    private final Int2ObjectMap<ItemDefinition> itemDefinitions;
    private final StoredItemMappings storedItems;
    private final Set<Item> javaOnlyItems;
    private final List<ItemDefinition> buckets;
    private final List<ItemDefinition> boats;
    private final Int2ObjectMap<String> customIdMappings;
    private final IntSet nonVanillaCustomItemIds;
    private final Object2ObjectMap<CustomBlockData, ItemDefinition> customBlockItemDefinitions;

    public ItemMapping getMapping(@NonNull GeyserItemStack itemStack) {
        return this.getMapping(itemStack.getJavaId());
    }

    public @NonNull ItemMapping getMapping(@NonNull ItemStack itemStack) {
        return this.getMapping(itemStack.getId());
    }

    public @NonNull ItemMapping getMapping(int javaId) {
        return javaId >= 0 && javaId < this.items.length ? this.items[javaId] : ItemMapping.AIR;
    }

    public @NonNull ItemMapping getMapping(Item javaItem) {
        return this.getMapping(javaItem.javaId());
    }

    public @Nullable ItemMapping getMapping(String javaIdentifier) {
        return this.cachedJavaMappings.computeIfAbsent(javaIdentifier, key -> {
            for (ItemMapping mapping : this.items) {
                if (!mapping.getJavaItem().javaIdentifier().equals(key)) continue;
                return mapping;
            }
            return null;
        });
    }

    public @NonNull ItemMapping getMapping(ItemData data) {
        ItemDefinition definition = data.getDefinition();
        if (ItemDefinition.AIR.equals(definition)) {
            return ItemMapping.AIR;
        }
        if (definition.getRuntimeId() == this.lodestoneCompass.getBedrockDefinition().getRuntimeId()) {
            return this.lodestoneCompass;
        }
        ItemMapping lightBlock = (ItemMapping)this.lightBlocks.get(definition.getRuntimeId());
        if (lightBlock != null) {
            return lightBlock;
        }
        boolean isBlock = data.getBlockDefinition() != null;
        boolean hasDamage = data.getDamage() != 0;
        for (ItemMapping mapping : this.items) {
            if (mapping.getBedrockDefinition().getRuntimeId() != definition.getRuntimeId() || (!isBlock || hasDamage ? mapping.getBedrockData() != data.getDamage() && !mapping.getJavaItem().ignoreDamage() && mapping.getJavaItem() != Items.SUSPICIOUS_STEW : data.getBlockDefinition() != mapping.getBedrockBlockDefinition())) continue;
            if (this.javaOnlyItems.contains(mapping.getJavaItem())) continue;
            return mapping;
        }
        GeyserImpl.getInstance().getLogger().debug("Missing mapping for bedrock item " + String.valueOf(data));
        return ItemMapping.AIR;
    }

    @Override
    public @Nullable ItemDefinition getDefinition(int bedrockId) {
        return (ItemDefinition)this.itemDefinitions.get(bedrockId);
    }

    public @Nullable ItemDefinition getDefinition(String bedrockIdentifier) {
        for (ItemDefinition itemDefinition : this.itemDefinitions.values()) {
            if (!itemDefinition.getIdentifier().equals(bedrockIdentifier)) continue;
            return itemDefinition;
        }
        return null;
    }

    @Override
    public boolean isRegistered(ItemDefinition definition) {
        return this.getDefinition(definition.getRuntimeId()) == definition;
    }

    ItemMappings(ItemMapping[] items, ItemMapping lodestoneCompass, Int2ObjectMap<ItemMapping> lightBlocks, List<CreativeItemGroup> creativeItemGroups, List<CreativeItemData> creativeItems, Int2ObjectMap<ItemDefinition> itemDefinitions, StoredItemMappings storedItems, Set<Item> javaOnlyItems, List<ItemDefinition> buckets, List<ItemDefinition> boats, Int2ObjectMap<String> customIdMappings, IntSet nonVanillaCustomItemIds, Object2ObjectMap<CustomBlockData, ItemDefinition> customBlockItemDefinitions) {
        this.items = items;
        this.lodestoneCompass = lodestoneCompass;
        this.lightBlocks = lightBlocks;
        this.creativeItemGroups = creativeItemGroups;
        this.creativeItems = creativeItems;
        this.itemDefinitions = itemDefinitions;
        this.storedItems = storedItems;
        this.javaOnlyItems = javaOnlyItems;
        this.buckets = buckets;
        this.boats = boats;
        this.customIdMappings = customIdMappings;
        this.nonVanillaCustomItemIds = nonVanillaCustomItemIds;
        this.customBlockItemDefinitions = customBlockItemDefinitions;
    }

    public static ItemMappingsBuilder builder() {
        return new ItemMappingsBuilder();
    }

    public Map<String, ItemMapping> getCachedJavaMappings() {
        return this.cachedJavaMappings;
    }

    public ItemMapping[] getItems() {
        return this.items;
    }

    public ItemMapping getLodestoneCompass() {
        return this.lodestoneCompass;
    }

    public Int2ObjectMap<ItemMapping> getLightBlocks() {
        return this.lightBlocks;
    }

    public List<CreativeItemGroup> getCreativeItemGroups() {
        return this.creativeItemGroups;
    }

    public List<CreativeItemData> getCreativeItems() {
        return this.creativeItems;
    }

    public Int2ObjectMap<ItemDefinition> getItemDefinitions() {
        return this.itemDefinitions;
    }

    public StoredItemMappings getStoredItems() {
        return this.storedItems;
    }

    public Set<Item> getJavaOnlyItems() {
        return this.javaOnlyItems;
    }

    public List<ItemDefinition> getBuckets() {
        return this.buckets;
    }

    public List<ItemDefinition> getBoats() {
        return this.boats;
    }

    public Int2ObjectMap<String> getCustomIdMappings() {
        return this.customIdMappings;
    }

    public IntSet getNonVanillaCustomItemIds() {
        return this.nonVanillaCustomItemIds;
    }

    public Object2ObjectMap<CustomBlockData, ItemDefinition> getCustomBlockItemDefinitions() {
        return this.customBlockItemDefinitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemMappings)) {
            return false;
        }
        ItemMappings other = (ItemMappings)o;
        Map<String, ItemMapping> this$cachedJavaMappings = this.getCachedJavaMappings();
        Map<String, ItemMapping> other$cachedJavaMappings = other.getCachedJavaMappings();
        if (this$cachedJavaMappings == null ? other$cachedJavaMappings != null : !((Object)this$cachedJavaMappings).equals(other$cachedJavaMappings)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getItems(), other.getItems())) {
            return false;
        }
        ItemMapping this$lodestoneCompass = this.getLodestoneCompass();
        ItemMapping other$lodestoneCompass = other.getLodestoneCompass();
        if (this$lodestoneCompass == null ? other$lodestoneCompass != null : !((Object)this$lodestoneCompass).equals(other$lodestoneCompass)) {
            return false;
        }
        Int2ObjectMap<ItemMapping> this$lightBlocks = this.getLightBlocks();
        Int2ObjectMap<ItemMapping> other$lightBlocks = other.getLightBlocks();
        if (this$lightBlocks == null ? other$lightBlocks != null : !this$lightBlocks.equals(other$lightBlocks)) {
            return false;
        }
        List<CreativeItemGroup> this$creativeItemGroups = this.getCreativeItemGroups();
        List<CreativeItemGroup> other$creativeItemGroups = other.getCreativeItemGroups();
        if (this$creativeItemGroups == null ? other$creativeItemGroups != null : !((Object)this$creativeItemGroups).equals(other$creativeItemGroups)) {
            return false;
        }
        List<CreativeItemData> this$creativeItems = this.getCreativeItems();
        List<CreativeItemData> other$creativeItems = other.getCreativeItems();
        if (this$creativeItems == null ? other$creativeItems != null : !((Object)this$creativeItems).equals(other$creativeItems)) {
            return false;
        }
        Int2ObjectMap<ItemDefinition> this$itemDefinitions = this.getItemDefinitions();
        Int2ObjectMap<ItemDefinition> other$itemDefinitions = other.getItemDefinitions();
        if (this$itemDefinitions == null ? other$itemDefinitions != null : !this$itemDefinitions.equals(other$itemDefinitions)) {
            return false;
        }
        StoredItemMappings this$storedItems = this.getStoredItems();
        StoredItemMappings other$storedItems = other.getStoredItems();
        if (this$storedItems == null ? other$storedItems != null : !this$storedItems.equals(other$storedItems)) {
            return false;
        }
        Set<Item> this$javaOnlyItems = this.getJavaOnlyItems();
        Set<Item> other$javaOnlyItems = other.getJavaOnlyItems();
        if (this$javaOnlyItems == null ? other$javaOnlyItems != null : !((Object)this$javaOnlyItems).equals(other$javaOnlyItems)) {
            return false;
        }
        List<ItemDefinition> this$buckets = this.getBuckets();
        List<ItemDefinition> other$buckets = other.getBuckets();
        if (this$buckets == null ? other$buckets != null : !((Object)this$buckets).equals(other$buckets)) {
            return false;
        }
        List<ItemDefinition> this$boats = this.getBoats();
        List<ItemDefinition> other$boats = other.getBoats();
        if (this$boats == null ? other$boats != null : !((Object)this$boats).equals(other$boats)) {
            return false;
        }
        Int2ObjectMap<String> this$customIdMappings = this.getCustomIdMappings();
        Int2ObjectMap<String> other$customIdMappings = other.getCustomIdMappings();
        if (this$customIdMappings == null ? other$customIdMappings != null : !this$customIdMappings.equals(other$customIdMappings)) {
            return false;
        }
        IntSet this$nonVanillaCustomItemIds = this.getNonVanillaCustomItemIds();
        IntSet other$nonVanillaCustomItemIds = other.getNonVanillaCustomItemIds();
        if (this$nonVanillaCustomItemIds == null ? other$nonVanillaCustomItemIds != null : !this$nonVanillaCustomItemIds.equals(other$nonVanillaCustomItemIds)) {
            return false;
        }
        Object2ObjectMap<CustomBlockData, ItemDefinition> this$customBlockItemDefinitions = this.getCustomBlockItemDefinitions();
        Object2ObjectMap<CustomBlockData, ItemDefinition> other$customBlockItemDefinitions = other.getCustomBlockItemDefinitions();
        return !(this$customBlockItemDefinitions == null ? other$customBlockItemDefinitions != null : !this$customBlockItemDefinitions.equals(other$customBlockItemDefinitions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ItemMapping> $cachedJavaMappings = this.getCachedJavaMappings();
        result = result * 59 + ($cachedJavaMappings == null ? 43 : ((Object)$cachedJavaMappings).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        ItemMapping $lodestoneCompass = this.getLodestoneCompass();
        result = result * 59 + ($lodestoneCompass == null ? 43 : ((Object)$lodestoneCompass).hashCode());
        Int2ObjectMap<ItemMapping> $lightBlocks = this.getLightBlocks();
        result = result * 59 + ($lightBlocks == null ? 43 : $lightBlocks.hashCode());
        List<CreativeItemGroup> $creativeItemGroups = this.getCreativeItemGroups();
        result = result * 59 + ($creativeItemGroups == null ? 43 : ((Object)$creativeItemGroups).hashCode());
        List<CreativeItemData> $creativeItems = this.getCreativeItems();
        result = result * 59 + ($creativeItems == null ? 43 : ((Object)$creativeItems).hashCode());
        Int2ObjectMap<ItemDefinition> $itemDefinitions = this.getItemDefinitions();
        result = result * 59 + ($itemDefinitions == null ? 43 : $itemDefinitions.hashCode());
        StoredItemMappings $storedItems = this.getStoredItems();
        result = result * 59 + ($storedItems == null ? 43 : $storedItems.hashCode());
        Set<Item> $javaOnlyItems = this.getJavaOnlyItems();
        result = result * 59 + ($javaOnlyItems == null ? 43 : ((Object)$javaOnlyItems).hashCode());
        List<ItemDefinition> $buckets = this.getBuckets();
        result = result * 59 + ($buckets == null ? 43 : ((Object)$buckets).hashCode());
        List<ItemDefinition> $boats = this.getBoats();
        result = result * 59 + ($boats == null ? 43 : ((Object)$boats).hashCode());
        Int2ObjectMap<String> $customIdMappings = this.getCustomIdMappings();
        result = result * 59 + ($customIdMappings == null ? 43 : $customIdMappings.hashCode());
        IntSet $nonVanillaCustomItemIds = this.getNonVanillaCustomItemIds();
        result = result * 59 + ($nonVanillaCustomItemIds == null ? 43 : $nonVanillaCustomItemIds.hashCode());
        Object2ObjectMap<CustomBlockData, ItemDefinition> $customBlockItemDefinitions = this.getCustomBlockItemDefinitions();
        result = result * 59 + ($customBlockItemDefinitions == null ? 43 : $customBlockItemDefinitions.hashCode());
        return result;
    }

    public String toString() {
        return "ItemMappings(cachedJavaMappings=" + String.valueOf(this.getCachedJavaMappings()) + ", items=" + Arrays.deepToString(this.getItems()) + ", lodestoneCompass=" + String.valueOf(this.getLodestoneCompass()) + ", lightBlocks=" + String.valueOf(this.getLightBlocks()) + ", creativeItemGroups=" + String.valueOf(this.getCreativeItemGroups()) + ", creativeItems=" + String.valueOf(this.getCreativeItems()) + ", itemDefinitions=" + String.valueOf(this.getItemDefinitions()) + ", storedItems=" + String.valueOf(this.getStoredItems()) + ", javaOnlyItems=" + String.valueOf(this.getJavaOnlyItems()) + ", buckets=" + String.valueOf(this.getBuckets()) + ", boats=" + String.valueOf(this.getBoats()) + ", customIdMappings=" + String.valueOf(this.getCustomIdMappings()) + ", nonVanillaCustomItemIds=" + String.valueOf(this.getNonVanillaCustomItemIds()) + ", customBlockItemDefinitions=" + String.valueOf(this.getCustomBlockItemDefinitions()) + ")";
    }

    public static class ItemMappingsBuilder {
        private ItemMapping[] items;
        private ItemMapping lodestoneCompass;
        private Int2ObjectMap<ItemMapping> lightBlocks;
        private List<CreativeItemGroup> creativeItemGroups;
        private List<CreativeItemData> creativeItems;
        private Int2ObjectMap<ItemDefinition> itemDefinitions;
        private StoredItemMappings storedItems;
        private Set<Item> javaOnlyItems;
        private List<ItemDefinition> buckets;
        private List<ItemDefinition> boats;
        private Int2ObjectMap<String> customIdMappings;
        private IntSet nonVanillaCustomItemIds;
        private Object2ObjectMap<CustomBlockData, ItemDefinition> customBlockItemDefinitions;

        ItemMappingsBuilder() {
        }

        public ItemMappingsBuilder items(ItemMapping[] items) {
            this.items = items;
            return this;
        }

        public ItemMappingsBuilder lodestoneCompass(ItemMapping lodestoneCompass) {
            this.lodestoneCompass = lodestoneCompass;
            return this;
        }

        public ItemMappingsBuilder lightBlocks(Int2ObjectMap<ItemMapping> lightBlocks) {
            this.lightBlocks = lightBlocks;
            return this;
        }

        public ItemMappingsBuilder creativeItemGroups(List<CreativeItemGroup> creativeItemGroups) {
            this.creativeItemGroups = creativeItemGroups;
            return this;
        }

        public ItemMappingsBuilder creativeItems(List<CreativeItemData> creativeItems) {
            this.creativeItems = creativeItems;
            return this;
        }

        public ItemMappingsBuilder itemDefinitions(Int2ObjectMap<ItemDefinition> itemDefinitions) {
            this.itemDefinitions = itemDefinitions;
            return this;
        }

        public ItemMappingsBuilder storedItems(StoredItemMappings storedItems) {
            this.storedItems = storedItems;
            return this;
        }

        public ItemMappingsBuilder javaOnlyItems(Set<Item> javaOnlyItems) {
            this.javaOnlyItems = javaOnlyItems;
            return this;
        }

        public ItemMappingsBuilder buckets(List<ItemDefinition> buckets) {
            this.buckets = buckets;
            return this;
        }

        public ItemMappingsBuilder boats(List<ItemDefinition> boats) {
            this.boats = boats;
            return this;
        }

        public ItemMappingsBuilder customIdMappings(Int2ObjectMap<String> customIdMappings) {
            this.customIdMappings = customIdMappings;
            return this;
        }

        public ItemMappingsBuilder nonVanillaCustomItemIds(IntSet nonVanillaCustomItemIds) {
            this.nonVanillaCustomItemIds = nonVanillaCustomItemIds;
            return this;
        }

        public ItemMappingsBuilder customBlockItemDefinitions(Object2ObjectMap<CustomBlockData, ItemDefinition> customBlockItemDefinitions) {
            this.customBlockItemDefinitions = customBlockItemDefinitions;
            return this;
        }

        public ItemMappings build() {
            return new ItemMappings(this.items, this.lodestoneCompass, this.lightBlocks, this.creativeItemGroups, this.creativeItems, this.itemDefinitions, this.storedItems, this.javaOnlyItems, this.buckets, this.boats, this.customIdMappings, this.nonVanillaCustomItemIds, this.customBlockItemDefinitions);
        }

        public String toString() {
            return "ItemMappings.ItemMappingsBuilder(items=" + Arrays.deepToString(this.items) + ", lodestoneCompass=" + String.valueOf(this.lodestoneCompass) + ", lightBlocks=" + String.valueOf(this.lightBlocks) + ", creativeItemGroups=" + String.valueOf(this.creativeItemGroups) + ", creativeItems=" + String.valueOf(this.creativeItems) + ", itemDefinitions=" + String.valueOf(this.itemDefinitions) + ", storedItems=" + String.valueOf(this.storedItems) + ", javaOnlyItems=" + String.valueOf(this.javaOnlyItems) + ", buckets=" + String.valueOf(this.buckets) + ", boats=" + String.valueOf(this.boats) + ", customIdMappings=" + String.valueOf(this.customIdMappings) + ", nonVanillaCustomItemIds=" + String.valueOf(this.nonVanillaCustomItemIds) + ", customBlockItemDefinitions=" + String.valueOf(this.customBlockItemDefinitions) + ")";
        }
    }
}

