/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.net.HostAndPort;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.geysermc.event.PostOrder;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.api.event.bedrock.SessionLoginEvent;
import org.geysermc.geyser.api.event.java.ServerTransferEvent;
import org.geysermc.geyser.session.GeyserSession;

public class GeyserServerTransferListener {
    private final Cache<String, Map<String, byte[]>> cookieStorages = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    @Subscribe(postOrder=PostOrder.FIRST)
    private void onServerTransfer(ServerTransferEvent event) {
        this.cookieStorages.put((Object)event.connection().xuid(), event.cookies());
        GeyserSession geyserSession = (GeyserSession)event.connection();
        HostAndPort hostAndPort = HostAndPort.fromString((String)geyserSession.getClientData().getServerAddress()).withDefaultPort(19132);
        event.bedrockHost(hostAndPort.getHost());
        event.bedrockPort(hostAndPort.getPort());
    }

    @Subscribe(postOrder=PostOrder.FIRST)
    private void onSessionLogin(SessionLoginEvent event) {
        Map cookies = (Map)this.cookieStorages.asMap().remove(event.connection().xuid());
        if (cookies != null) {
            event.cookies(cookies);
            event.transferring(true);
        }
    }
}

