/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;

public class RequiredTypeConverter<T>
implements Converter<T, Object> {
    private final Class<T> type;

    public RequiredTypeConverter(Class<T> type) {
        this.type = Assert.notNull(type, "type argument cannot be null.");
    }

    @Override
    public Object applyTo(T t) {
        return t;
    }

    @Override
    public T applyFrom(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> clazz = o.getClass();
        if (!this.type.isAssignableFrom(clazz)) {
            String msg = "Unsupported value type. Expected: " + this.type.getName() + ", found: " + clazz.getName();
            throw new IllegalArgumentException(msg);
        }
        return this.type.cast(o);
    }
}

