/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundSetEntityMotionPacket
implements MinecraftPacket {
    private final int entityId;
    private final Vector3d movement;

    public ClientboundSetEntityMotionPacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        this.movement = MinecraftTypes.readLpVec3(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        MinecraftTypes.writeLpVec3(out, this.movement);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Vector3d getMovement() {
        return this.movement;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetEntityMotionPacket)) {
            return false;
        }
        ClientboundSetEntityMotionPacket other = (ClientboundSetEntityMotionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        Vector3d this$movement = this.getMovement();
        Vector3d other$movement = other.getMovement();
        return !(this$movement == null ? other$movement != null : !this$movement.equals(other$movement));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetEntityMotionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        Vector3d $movement = this.getMovement();
        result = result * 59 + ($movement == null ? 43 : $movement.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetEntityMotionPacket(entityId=" + this.getEntityId() + ", movement=" + String.valueOf(this.getMovement()) + ")";
    }

    public @NonNull ClientboundSetEntityMotionPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSetEntityMotionPacket(entityId, this.movement);
    }

    public @NonNull ClientboundSetEntityMotionPacket withMovement(Vector3d movement) {
        return this.movement == movement ? this : new ClientboundSetEntityMotionPacket(this.entityId, movement);
    }

    public ClientboundSetEntityMotionPacket(int entityId, Vector3d movement) {
        this.entityId = entityId;
        this.movement = movement;
    }
}

