/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.MinecartStep;

public class ClientboundMoveMinecartPacket
implements MinecraftPacket {
    private int entityId;
    private List<MinecartStep> lerpSteps;

    public ClientboundMoveMinecartPacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        this.lerpSteps = MinecraftTypes.readList(in, input -> {
            Vector3d position = Vector3d.from(input.readDouble(), input.readDouble(), input.readDouble());
            Vector3d movement = Vector3d.from(input.readDouble(), input.readDouble(), input.readDouble());
            float yRot = (float)input.readByte() * 360.0f / 256.0f;
            float xRot = (float)input.readByte() * 360.0f / 256.0f;
            float weight = input.readFloat();
            return new MinecartStep(position, movement, yRot, xRot, weight);
        });
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        MinecraftTypes.writeList(out, this.lerpSteps, (output, lerpStep) -> {
            output.writeDouble(lerpStep.position().getX());
            output.writeDouble(lerpStep.position().getY());
            output.writeDouble(lerpStep.position().getZ());
            output.writeDouble(lerpStep.movement().getX());
            output.writeDouble(lerpStep.movement().getY());
            output.writeDouble(lerpStep.movement().getZ());
            float yRot = lerpStep.yRot() * 256.0f / 360.0f;
            output.writeByte(yRot < (float)((int)yRot) ? (int)yRot - 1 : (int)yRot);
            float xRot = lerpStep.xRot() * 256.0f / 360.0f;
            output.writeByte(xRot < (float)((int)xRot) ? (int)xRot - 1 : (int)xRot);
            output.writeFloat(lerpStep.weight());
        });
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public List<MinecartStep> getLerpSteps() {
        return this.lerpSteps;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setLerpSteps(List<MinecartStep> lerpSteps) {
        this.lerpSteps = lerpSteps;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundMoveMinecartPacket)) {
            return false;
        }
        ClientboundMoveMinecartPacket other = (ClientboundMoveMinecartPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        List<MinecartStep> this$lerpSteps = this.getLerpSteps();
        List<MinecartStep> other$lerpSteps = other.getLerpSteps();
        return !(this$lerpSteps == null ? other$lerpSteps != null : !((Object)this$lerpSteps).equals(other$lerpSteps));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundMoveMinecartPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        List<MinecartStep> $lerpSteps = this.getLerpSteps();
        result = result * 59 + ($lerpSteps == null ? 43 : ((Object)$lerpSteps).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundMoveMinecartPacket(entityId=" + this.getEntityId() + ", lerpSteps=" + String.valueOf(this.getLerpSteps()) + ")";
    }

    public @NonNull ClientboundMoveMinecartPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundMoveMinecartPacket(entityId, this.lerpSteps);
    }

    public @NonNull ClientboundMoveMinecartPacket withLerpSteps(List<MinecartStep> lerpSteps) {
        return this.lerpSteps == lerpSteps ? this : new ClientboundMoveMinecartPacket(this.entityId, lerpSteps);
    }

    public ClientboundMoveMinecartPacket(int entityId, List<MinecartStep> lerpSteps) {
        this.entityId = entityId;
        this.lerpSteps = lerpSteps;
    }
}

