/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;

public abstract class DataComponent<V, T extends DataComponentType<V>> {
    protected final @NonNull T type;

    public abstract V getValue();

    public void write(ByteBuf out) {
        ((DataComponentType)this.type).writeDataComponent(out, this.getValue());
    }

    public String toString() {
        return "DataComponent(type=" + String.valueOf(this.type) + ", value=" + this.getValue().toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataComponent)) {
            return false;
        }
        DataComponent that = (DataComponent)o;
        return this.type == that.type && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.getValue());
    }

    public @NonNull T getType() {
        return this.type;
    }

    public DataComponent(@NonNull T type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }
}

