/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;
import org.jetbrains.annotations.Nullable;

public record BlocksAttacks(float blockDelaySeconds, float disableCooldownScale, List<DamageReduction> damageReductions, ItemDamageFunction itemDamage, @Nullable Key bypassedBy, @Nullable Sound blockSound, @Nullable Sound disableSound) {
    public BlocksAttacks(float blockDelaySeconds, float disableCooldownScale, List<DamageReduction> damageReductions, ItemDamageFunction itemDamage, @Nullable Key bypassedBy, @Nullable Sound blockSound, @Nullable Sound disableSound) {
        this.blockDelaySeconds = blockDelaySeconds;
        this.disableCooldownScale = disableCooldownScale;
        this.damageReductions = List.copyOf(damageReductions);
        this.itemDamage = itemDamage;
        this.bypassedBy = bypassedBy;
        this.blockSound = blockSound;
        this.disableSound = disableSound;
    }

    public static @NonNull BlocksAttacksBuilder builder() {
        return new BlocksAttacksBuilder();
    }

    public @NonNull BlocksAttacksBuilder toBuilder() {
        return new BlocksAttacksBuilder().blockDelaySeconds(this.blockDelaySeconds).disableCooldownScale(this.disableCooldownScale).damageReductions(this.damageReductions).itemDamage(this.itemDamage).bypassedBy(this.bypassedBy).blockSound(this.blockSound).disableSound(this.disableSound);
    }

    public record ItemDamageFunction(float threshold, float base, float factor) {
        public static @NonNull ItemDamageFunctionBuilder builder() {
            return new ItemDamageFunctionBuilder();
        }

        public @NonNull ItemDamageFunctionBuilder toBuilder() {
            return new ItemDamageFunctionBuilder().threshold(this.threshold).base(this.base).factor(this.factor);
        }

        public static class ItemDamageFunctionBuilder {
            private float threshold;
            private float base;
            private float factor;

            ItemDamageFunctionBuilder() {
            }

            public @NonNull ItemDamageFunctionBuilder threshold(float threshold) {
                this.threshold = threshold;
                return this;
            }

            public @NonNull ItemDamageFunctionBuilder base(float base) {
                this.base = base;
                return this;
            }

            public @NonNull ItemDamageFunctionBuilder factor(float factor) {
                this.factor = factor;
                return this;
            }

            public @NonNull ItemDamageFunction build() {
                return new ItemDamageFunction(this.threshold, this.base, this.factor);
            }

            public @NonNull String toString() {
                return "BlocksAttacks.ItemDamageFunction.ItemDamageFunctionBuilder(threshold=" + this.threshold + ", base=" + this.base + ", factor=" + this.factor + ")";
            }
        }
    }

    public static class BlocksAttacksBuilder {
        private float blockDelaySeconds;
        private float disableCooldownScale;
        private List<DamageReduction> damageReductions;
        private ItemDamageFunction itemDamage;
        private Key bypassedBy;
        private Sound blockSound;
        private Sound disableSound;

        BlocksAttacksBuilder() {
        }

        public @NonNull BlocksAttacksBuilder blockDelaySeconds(float blockDelaySeconds) {
            this.blockDelaySeconds = blockDelaySeconds;
            return this;
        }

        public @NonNull BlocksAttacksBuilder disableCooldownScale(float disableCooldownScale) {
            this.disableCooldownScale = disableCooldownScale;
            return this;
        }

        public @NonNull BlocksAttacksBuilder damageReductions(List<DamageReduction> damageReductions) {
            this.damageReductions = damageReductions;
            return this;
        }

        public @NonNull BlocksAttacksBuilder itemDamage(ItemDamageFunction itemDamage) {
            this.itemDamage = itemDamage;
            return this;
        }

        public @NonNull BlocksAttacksBuilder bypassedBy(@Nullable Key bypassedBy) {
            this.bypassedBy = bypassedBy;
            return this;
        }

        public @NonNull BlocksAttacksBuilder blockSound(@Nullable Sound blockSound) {
            this.blockSound = blockSound;
            return this;
        }

        public @NonNull BlocksAttacksBuilder disableSound(@Nullable Sound disableSound) {
            this.disableSound = disableSound;
            return this;
        }

        public @NonNull BlocksAttacks build() {
            return new BlocksAttacks(this.blockDelaySeconds, this.disableCooldownScale, this.damageReductions, this.itemDamage, this.bypassedBy, this.blockSound, this.disableSound);
        }

        public @NonNull String toString() {
            return "BlocksAttacks.BlocksAttacksBuilder(blockDelaySeconds=" + this.blockDelaySeconds + ", disableCooldownScale=" + this.disableCooldownScale + ", damageReductions=" + String.valueOf(this.damageReductions) + ", itemDamage=" + String.valueOf(this.itemDamage) + ", bypassedBy=" + String.valueOf(this.bypassedBy) + ", blockSound=" + String.valueOf(this.blockSound) + ", disableSound=" + String.valueOf(this.disableSound) + ")";
        }
    }

    public record DamageReduction(float horizontalBlockingAngle, @Nullable HolderSet type, float base, float factor) {
        public static @NonNull DamageReductionBuilder builder() {
            return new DamageReductionBuilder();
        }

        public @NonNull DamageReductionBuilder toBuilder() {
            return new DamageReductionBuilder().horizontalBlockingAngle(this.horizontalBlockingAngle).type(this.type).base(this.base).factor(this.factor);
        }

        public static class DamageReductionBuilder {
            private float horizontalBlockingAngle;
            private HolderSet type;
            private float base;
            private float factor;

            DamageReductionBuilder() {
            }

            public @NonNull DamageReductionBuilder horizontalBlockingAngle(float horizontalBlockingAngle) {
                this.horizontalBlockingAngle = horizontalBlockingAngle;
                return this;
            }

            public @NonNull DamageReductionBuilder type(@Nullable HolderSet type) {
                this.type = type;
                return this;
            }

            public @NonNull DamageReductionBuilder base(float base) {
                this.base = base;
                return this;
            }

            public @NonNull DamageReductionBuilder factor(float factor) {
                this.factor = factor;
                return this;
            }

            public @NonNull DamageReduction build() {
                return new DamageReduction(this.horizontalBlockingAngle, this.type, this.base, this.factor);
            }

            public @NonNull String toString() {
                return "BlocksAttacks.DamageReduction.DamageReductionBuilder(horizontalBlockingAngle=" + this.horizontalBlockingAngle + ", type=" + String.valueOf(this.type) + ", base=" + this.base + ", factor=" + this.factor + ")";
            }
        }
    }
}

