/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.sound.block;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.sound.BlockSoundInteractionTranslator;
import org.geysermc.geyser.translator.sound.SoundTranslator;

@SoundTranslator(items={"bucket"}, ignoreSneakingWhileHolding=true)
public class BucketSoundInteractionTranslator
implements BlockSoundInteractionTranslator {
    @Override
    public void translate(GeyserSession session, Vector3f position, BlockState state) {
        String identifier = state.toString();
        if (!session.isPlacedBucket()) {
            return;
        }
        GeyserItemStack itemStack = session.getPlayerInventory().getItemInHand();
        String handItemIdentifier = itemStack.asItem().javaIdentifier();
        if (!BlockSoundInteractionTranslator.canInteract(session, itemStack, identifier)) {
            return;
        }
        LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
        soundEventPacket.setPosition(position);
        soundEventPacket.setIdentifier(":");
        soundEventPacket.setRelativeVolumeDisabled(false);
        soundEventPacket.setBabySound(false);
        soundEventPacket.setExtraData(-1);
        SoundEvent soundEvent = null;
        switch (handItemIdentifier) {
            case "minecraft:bucket": {
                if (identifier.contains("water[")) {
                    soundEvent = SoundEvent.BUCKET_FILL_WATER;
                    break;
                }
                if (identifier.contains("lava[")) {
                    soundEvent = SoundEvent.BUCKET_FILL_LAVA;
                    break;
                }
                if (!identifier.contains("powder_snow")) break;
                soundEvent = SoundEvent.BUCKET_FILL_POWDER_SNOW;
                break;
            }
            case "minecraft:lava_bucket": {
                soundEvent = SoundEvent.BUCKET_EMPTY_LAVA;
                break;
            }
            case "minecraft:axolotl_bucket": 
            case "minecraft:cod_bucket": 
            case "minecraft:salmon_bucket": 
            case "minecraft:pufferfish_bucket": 
            case "minecraft:tropical_fish_bucket": 
            case "minecraft:tadpole_bucket": {
                soundEvent = SoundEvent.BUCKET_EMPTY_FISH;
                break;
            }
            case "minecraft:water_bucket": {
                soundEvent = SoundEvent.BUCKET_EMPTY_WATER;
                break;
            }
            case "minecraft:powder_snow_bucket": {
                soundEvent = SoundEvent.BUCKET_EMPTY_POWDER_SNOW;
            }
        }
        if (soundEvent != null) {
            soundEventPacket.setSound(soundEvent);
            session.sendUpstreamPacket(soundEventPacket);
            session.setPlacedBucket(false);
        }
    }
}

