/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.Pair;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.BlockBreakStage;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundBlockDestructionPacket;

@Translator(packet=ClientboundBlockDestructionPacket.class)
public class JavaBlockDestructionTranslator
extends PacketTranslator<ClientboundBlockDestructionPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundBlockDestructionPacket packet) {
        if (packet.getStage() == BlockBreakStage.RESET) {
            session.getBlockBreakHandler().getDestructionStageCache().invalidate((Object)packet.getPosition());
            BlockUtils.sendBedrockStopBlockBreak(session, packet.getPosition().toFloat());
            return;
        }
        LevelEventPacket levelEventPacket = new LevelEventPacket();
        levelEventPacket.setPosition(packet.getPosition().toFloat());
        Pair lastUpdate = (Pair)session.getBlockBreakHandler().getDestructionStageCache().getIfPresent((Object)packet.getPosition());
        if (lastUpdate == null) {
            levelEventPacket.setType(LevelEvent.BLOCK_START_BREAK);
            levelEventPacket.setData(10);
        } else {
            int ticksSince = (int)(session.getClientTicks() - (Long)lastUpdate.first());
            int stagesSince = packet.getStage().compareTo((BlockBreakStage)((Object)lastUpdate.second()));
            int ticksPerStage = stagesSince == 0 ? ticksSince : ticksSince / stagesSince;
            int remainingStages = 10 - packet.getStage().ordinal();
            levelEventPacket.setType(LevelEvent.BLOCK_UPDATE_BREAK);
            levelEventPacket.setData(65535 / Math.max(remainingStages, 1) * Math.max(ticksPerStage, 1));
        }
        session.getBlockBreakHandler().getDestructionStageCache().put((Object)packet.getPosition(), Pair.of(session.getClientTicks(), packet.getStage()));
        session.sendUpstreamPacket(levelEventPacket);
    }
}

