/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import java.util.BitSet;
import java.util.List;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventoryActionData;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventorySource;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventoryTransactionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.LegacySetItemSlotData;
import org.cloudburstmc.protocol.bedrock.packet.ContainerOpenPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventoryTransactionPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.click.Click;
import org.geysermc.geyser.inventory.item.GeyserInstrument;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.hashing.DataComponentHashers;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.BoatItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.item.type.SpawnEggItem;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.ButtonBlock;
import org.geysermc.geyser.level.block.type.CauldronBlock;
import org.geysermc.geyser.level.block.type.DoorBlock;
import org.geysermc.geyser.level.block.type.FlowerPotBlock;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.FakeHeadProvider;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.geyser.util.SoundUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.InteractAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.InstrumentComponent;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClickPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundSwingPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundUseItemOnPacket;

@Translator(packet=InventoryTransactionPacket.class)
public class BedrockInventoryTransactionTranslator
extends PacketTranslator<InventoryTransactionPacket> {
    @Override
    public void translate(GeyserSession session, InventoryTransactionPacket packet) {
        InventoryActionData containerAction;
        if (packet.getTransactionType() == InventoryTransactionType.NORMAL && packet.getActions().size() == 3 && (containerAction = packet.getActions().get(0)).getSource().getType() == InventorySource.Type.CONTAINER && session.getPlayerInventory().getHeldItemSlot() == containerAction.getSlot() && containerAction.getFromItem().getDefinition() == session.getItemMappings().getStoredItems().writableBook().getBedrockDefinition()) {
            return;
        }
        session.getBookEditCache().checkForSend();
        block0 : switch (packet.getTransactionType()) {
            case NORMAL: {
                boolean dropAll;
                if (packet.getActions().size() != 2) break;
                InventoryActionData worldAction = packet.getActions().get(0);
                InventoryActionData containerAction2 = packet.getActions().get(1);
                if (worldAction.getSource().getType() != InventorySource.Type.WORLD_INTERACTION || worldAction.getSource().getFlag() != InventorySource.Flag.DROP_ITEM) break;
                boolean bl = dropAll = worldAction.getToItem().getCount() > 1;
                if (session.getPlayerInventory().getHeldItemSlot() != containerAction2.getSlot()) {
                    Int2ObjectMap<Object> changedItem;
                    Click clickType;
                    PlayerInventory inventory = session.getPlayerInventory();
                    int hotbarSlot = inventory.getOffsetForHotbar(containerAction2.getSlot());
                    Click click = clickType = dropAll ? Click.DROP_ALL : Click.DROP_ONE;
                    if (dropAll) {
                        inventory.setItem(hotbarSlot, GeyserItemStack.EMPTY, session);
                        changedItem = Int2ObjectMaps.singleton(hotbarSlot, null);
                    } else {
                        GeyserItemStack itemStack = inventory.getItem(hotbarSlot);
                        if (itemStack.isEmpty()) {
                            return;
                        }
                        itemStack.sub(1);
                        changedItem = Int2ObjectMaps.singleton(hotbarSlot, DataComponentHashers.hashStack(session, itemStack.getItemStack()));
                    }
                    ServerboundContainerClickPacket dropPacket = new ServerboundContainerClickPacket(inventory.getJavaId(), inventory.getStateId(), hotbarSlot, clickType.actionType, clickType.action, DataComponentHashers.hashStack(session, inventory.getCursor().getItemStack()), changedItem);
                    session.sendDownstreamGamePacket(dropPacket);
                    return;
                }
                if (session.getPlayerInventory().getItemInHand().isEmpty()) {
                    return;
                }
                ServerboundPlayerActionPacket dropPacket = new ServerboundPlayerActionPacket(dropAll ? PlayerAction.DROP_ITEM_STACK : PlayerAction.DROP_ITEM, Vector3i.ZERO, org.geysermc.geyser.level.physics.Direction.DOWN.mcpl(), 0);
                session.sendDownstreamGamePacket(dropPacket);
                if (dropAll) {
                    session.getPlayerInventory().setItemInHand(GeyserItemStack.EMPTY);
                    break;
                }
                session.getPlayerInventory().getItemInHand().sub(1);
                break;
            }
            case INVENTORY_MISMATCH: {
                break;
            }
            case ITEM_USE: {
                switch (packet.getActionType()) {
                    case 0: {
                        ItemFrameEntity itemFrameEntity;
                        Vector3i packetBlockPosition = packet.getBlockPosition();
                        Vector3i blockPos = BlockUtils.getBlockPosition(packetBlockPosition, org.geysermc.geyser.level.physics.Direction.getUntrusted(packet, InventoryTransactionPacket::getBlockFace));
                        if (session.getGeyser().config().gameplay().disableBedrockScaffolding()) {
                            boolean isGodBridging;
                            float yaw = session.getPlayerEntity().getYaw();
                            switch (packet.getBlockFace()) {
                                case 2: {
                                    boolean bl;
                                    if (yaw <= -135.0f || yaw > 135.0f) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                case 3: {
                                    boolean bl;
                                    if (yaw <= 45.0f && yaw > -45.0f) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                case 4: {
                                    boolean bl;
                                    if (yaw > 45.0f && yaw <= 135.0f) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                case 5: {
                                    boolean bl;
                                    if (yaw <= -45.0f && yaw > -135.0f) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                default: {
                                    boolean bl = isGodBridging = false;
                                }
                            }
                            if (isGodBridging) {
                                BlockUtils.restoreCorrectBlock(session, blockPos);
                                return;
                            }
                        }
                        if (!session.getBlockMappings().getExtendedCollisionBoxes().isEmpty()) {
                            Vector3i belowBlockPos = null;
                            switch (packet.getBlockFace()) {
                                case 1: {
                                    belowBlockPos = blockPos.add(0, -2, 0);
                                    break;
                                }
                                case 2: {
                                    belowBlockPos = blockPos.add(0, -1, 1);
                                    break;
                                }
                                case 3: {
                                    belowBlockPos = blockPos.add(0, -1, -1);
                                    break;
                                }
                                case 4: {
                                    belowBlockPos = blockPos.add(1, -1, 0);
                                    break;
                                }
                                case 5: {
                                    belowBlockPos = blockPos.add(-1, -1, 0);
                                }
                            }
                            if (belowBlockPos != null) {
                                int belowBlock = session.getGeyser().getWorldManager().getBlockAt(session, belowBlockPos);
                                BlockDefinition extendedCollisionDefinition = (BlockDefinition)session.getBlockMappings().getExtendedCollisionBoxes().get(belowBlock);
                                if (extendedCollisionDefinition != null && System.currentTimeMillis() - session.getLastInteractionTime() < 200L) {
                                    BlockUtils.restoreCorrectBlock(session, blockPos);
                                    return;
                                }
                            }
                        }
                        boolean hasAlreadyClicked = (double)(System.currentTimeMillis() - session.getLastInteractionTime()) < 110.0 && (double)packetBlockPosition.distanceSquared(session.getLastInteractionBlockPosition()) < 1.0E-5;
                        session.setLastInteractionBlockPosition(packetBlockPosition);
                        session.setLastInteractionPlayerPosition(session.getPlayerEntity().getPosition());
                        if (hasAlreadyClicked) break;
                        session.setLastInteractionTime(System.currentTimeMillis());
                        if (this.isIncorrectHeldItem(session, packet)) {
                            BlockUtils.restoreCorrectBlock(session, blockPos);
                            return;
                        }
                        if (session.getBlockMappings().isItemFrame(packet.getBlockDefinition()) && (itemFrameEntity = ItemFrameEntity.getItemFrameEntity(session, packet.getBlockPosition())) != null) {
                            this.processEntityInteraction(session, packet, itemFrameEntity);
                            break;
                        }
                        if (!session.getWorldBorder().isInsideBorderBoundaries()) {
                            BlockUtils.restoreCorrectBlock(session, blockPos);
                            return;
                        }
                        Vector3f playerPosition = session.getPlayerEntity().getPosition();
                        if (!BedrockInventoryTransactionTranslator.canInteractWithBlock(session, playerPosition = playerPosition.down(EntityDefinitions.PLAYER.offset() - session.getEyeHeight()), packetBlockPosition)) {
                            BlockUtils.restoreCorrectBlock(session, blockPos);
                            return;
                        }
                        double clickPositionFullX = (double)packetBlockPosition.getX() + (double)packet.getClickPosition().getX();
                        double clickPositionFullY = (double)packetBlockPosition.getY() + (double)packet.getClickPosition().getY();
                        double clickPositionFullZ = (double)packetBlockPosition.getZ() + (double)packet.getClickPosition().getZ();
                        Vector3f blockCenter = Vector3f.from((float)packetBlockPosition.getX() + 0.5f, (float)packetBlockPosition.getY() + 0.5f, (float)packetBlockPosition.getZ() + 0.5f);
                        double clickDistanceX = clickPositionFullX - (double)blockCenter.getX();
                        double clickDistanceY = clickPositionFullY - (double)blockCenter.getY();
                        double clickDistanceZ = clickPositionFullZ - (double)blockCenter.getZ();
                        if (!(Math.abs(clickDistanceX) < 1.0000001 && Math.abs(clickDistanceY) < 1.0000001 && Math.abs(clickDistanceZ) < 1.0000001)) {
                            BlockUtils.restoreCorrectBlock(session, blockPos);
                            return;
                        }
                        BlockState blockState = session.getGeyser().getWorldManager().blockAt(session, packet.getBlockPosition());
                        if (blockState.block() instanceof ButtonBlock && blockState.getValue(Properties.POWERED).booleanValue()) {
                            return;
                        }
                        if (blockState.block() instanceof DoorBlock) {
                            session.setLastLowerDoorPosition(null);
                        }
                        if (packet.getItemInHand() != null && session.getItemMappings().getMapping(packet.getItemInHand()).getJavaItem() instanceof SpawnEggItem && blockState.is(Blocks.WATER) && blockState.getValue(Properties.LEVEL) == 0) {
                            this.useItem(session, packet, blockState.javaId(), false);
                            break;
                        }
                        int sequence = session.getWorldCache().nextPredictionSequence();
                        session.getWorldCache().markPositionInSequence(blockPos);
                        ServerboundUseItemOnPacket blockPacket = new ServerboundUseItemOnPacket(packet.getBlockPosition(), org.geysermc.geyser.level.physics.Direction.getUntrusted(packet, InventoryTransactionPacket::getBlockFace).mcpl(), Hand.MAIN_HAND, packet.getClickPosition().getX(), packet.getClickPosition().getY(), packet.getClickPosition().getZ(), false, false, sequence);
                        session.sendDownstreamGamePacket(blockPacket);
                        Item item = session.getPlayerInventory().getItemInHand().asItem();
                        if (packet.getItemInHand() != null) {
                            FlowerPotBlock flowerPotBlock;
                            ItemDefinition definition = packet.getItemInHand().getDefinition();
                            if (item instanceof BoatItem || item == Items.LILY_PAD || item == Items.FROGSPAWN) {
                                this.useItem(session, packet, blockState.javaId(), true);
                            } else if (item == Items.GLASS_BOTTLE) {
                                Block block = blockState.block();
                                if (!session.isSneaking() && block instanceof CauldronBlock && block != Blocks.WATER_CAULDRON) {
                                    return;
                                }
                                this.useItem(session, packet, blockState.javaId(), true);
                            } else if (session.getItemMappings().getBuckets().contains(definition)) {
                                if (definition != session.getItemMappings().getStoredItems().powderSnowBucket().getBedrockDefinition()) {
                                    if (!session.isSneaking() && blockState.block() instanceof CauldronBlock) {
                                        return;
                                    }
                                    session.setPlacedBucket(this.useItem(session, packet, blockState.javaId(), true));
                                } else {
                                    session.setPlacedBucket(true);
                                }
                            }
                            Block block = blockState.block();
                            if (block instanceof FlowerPotBlock && (flowerPotBlock = (FlowerPotBlock)block).flower() != Blocks.AIR) {
                                Item mightStackHere = flowerPotBlock.flower().asItem();
                                for (int i = 0; i < 36; ++i) {
                                    GeyserItemStack stack;
                                    int slot = i;
                                    if (i < 9) {
                                        slot = session.getPlayerInventory().getOffsetForHotbar(slot);
                                    }
                                    if (!(stack = session.getPlayerInventory().getItem(slot)).isEmpty() && !stack.is(mightStackHere)) continue;
                                    session.getPlayerInventoryHolder().updateSlot(slot);
                                    break;
                                }
                            }
                        }
                        if (packet.getActions().isEmpty() && session.getOpPermissionLevel() >= 2 && session.getGameMode() == GameMode.CREATIVE) {
                            if (session.getBlockMappings().getJigsawStates().contains(packet.getBlockDefinition())) {
                                openPacket = new ContainerOpenPacket();
                                openPacket.setBlockPosition(packet.getBlockPosition());
                                openPacket.setId((byte)1);
                                openPacket.setType(ContainerType.JIGSAW_EDITOR);
                                openPacket.setUniqueEntityId(-1L);
                                session.sendUpstreamPacket(openPacket);
                            } else if (session.getBlockMappings().getStructureBlockStates().containsValue(packet.getBlockDefinition())) {
                                openPacket = new ContainerOpenPacket();
                                openPacket.setBlockPosition(packet.getBlockPosition());
                                openPacket.setId((byte)1);
                                openPacket.setType(ContainerType.STRUCTURE_EDITOR);
                                openPacket.setUniqueEntityId(-1L);
                                session.sendUpstreamPacket(openPacket);
                            }
                        }
                        if (item instanceof BlockItem) {
                            BlockItem blockItem = (BlockItem)item;
                            session.setLastBlockPlacePosition(blockPos);
                            session.setLastBlockPlaced(blockItem);
                        }
                        session.setInteracting(true);
                        break;
                    }
                    case 1: {
                        GeyserItemStack armorSlotItem;
                        int bedrockHotbarSlot;
                        Click click;
                        if (this.isIncorrectHeldItem(session, packet)) {
                            session.getPlayerInventoryHolder().updateSlot(session.getPlayerInventory().getOffsetForHotbar(packet.getHotbarSlot()));
                            break;
                        }
                        if (session.getPlayerInventory().getItemInHand().is(Items.SHIELD)) break;
                        if (packet.getItemInHand() != null) {
                            InstrumentComponent component;
                            if (session.getItemMappings().getBuckets().contains(packet.getItemInHand().getDefinition()) && packet.getItemInHand().getDefinition() != session.getItemMappings().getStoredItems().milkBucket().getBedrockDefinition() || session.getItemMappings().getMapping(packet.getItemInHand()).getJavaItem() instanceof SpawnEggItem || packet.getItemInHand().getDefinition() == session.getItemMappings().getStoredItems().glassBottle().getBedrockDefinition()) break;
                            if (packet.getItemInHand().getDefinition() == session.getItemMappings().getStoredItems().writtenBook().getBedrockDefinition()) {
                                session.setCurrentBook(packet.getItemInHand());
                            } else if (session.getPlayerInventory().getItemInHand().is(Items.GOAT_HORN) && !session.getWorldCache().hasCooldown(session.getPlayerInventory().getItemInHand()) && (component = session.getPlayerInventory().getItemInHand().getComponent(DataComponentTypes.INSTRUMENT)) != null) {
                                GeyserInstrument instrument = GeyserInstrument.fromComponent(session, component);
                                if (instrument.bedrockInstrument() != null) {
                                    LevelSoundEventPacket soundPacket = new LevelSoundEventPacket();
                                    soundPacket.setSound(SoundEvent.valueOf("GOAT_CALL_" + instrument.bedrockInstrument().ordinal()));
                                    soundPacket.setPosition(session.getPlayerEntity().getPosition());
                                    soundPacket.setIdentifier("minecraft:player");
                                    soundPacket.setExtraData(-1);
                                    session.sendUpstreamPacket(soundPacket);
                                } else {
                                    PlaySoundPacket playSoundPacket = new PlaySoundPacket();
                                    playSoundPacket.setPosition(session.getPlayerEntity().position());
                                    playSoundPacket.setSound(SoundUtils.translatePlaySound(instrument.soundEvent()));
                                    playSoundPacket.setPitch(1.0f);
                                    playSoundPacket.setVolume(instrument.range() / 16.0f);
                                    session.sendUpstreamPacket(playSoundPacket);
                                }
                            }
                        }
                        session.useItem(Hand.MAIN_HAND);
                        session.getBundleCache().awaitRelease();
                        List<LegacySetItemSlotData> legacySlots = packet.getLegacySlots();
                        if (packet.getActions().size() != 1 || legacySlots.isEmpty()) break block0;
                        InventoryActionData actionData = packet.getActions().get(0);
                        LegacySetItemSlotData slotData = legacySlots.get(0);
                        if (slotData.getContainerId() != 6 || actionData.getFromItem().isNull() || (click = InventoryUtils.getClickForHotbarSwap(bedrockHotbarSlot = packet.getHotbarSlot())) == null || slotData.getSlots().length == 0) break block0;
                        PlayerInventory playerInventory = session.getPlayerInventory();
                        int armorSlot = slotData.getSlots()[0] + 5;
                        if (armorSlot != 5 || !(armorSlotItem = playerInventory.getItem(armorSlot)).is(Items.PLAYER_HEAD)) break block0;
                        FakeHeadProvider.restoreOriginalSkin(session, session.getPlayerEntity());
                        break;
                    }
                    case 3: {
                        if (session.getPlayerInventory().getItemInHand().getComponent(DataComponentTypes.PIERCING_WEAPON) != null && session.getGameMode() != GameMode.SPECTATOR) {
                            session.sendDownstreamPacket(new ServerboundPlayerActionPacket(PlayerAction.STAB, Vector3i.ZERO, Direction.DOWN, 0));
                            session.sendDownstreamPacket(new ServerboundSwingPacket(Hand.MAIN_HAND));
                            CooldownUtils.sendCooldown(session);
                        } else {
                            break;
                        }
                    }
                }
                break;
            }
            case ITEM_RELEASE: {
                if (packet.getActionType() != 0) break;
                session.getPlayerEntity().setFlag(EntityFlag.USING_ITEM, false);
                session.releaseItem();
                session.getBundleCache().markRelease();
                break;
            }
            case ITEM_USE_ON_ENTITY: {
                if (session.getPlayerInventory().getItemInHand().getComponent(DataComponentTypes.PIERCING_WEAPON) != null && session.getGameMode() != GameMode.SPECTATOR) {
                    return;
                }
                Entity entity = session.getEntityCache().getEntityByGeyserId(packet.getRuntimeEntityId());
                if (entity == null) {
                    return;
                }
                switch (packet.getActionType()) {
                    case 0: {
                        this.processEntityInteraction(session, packet, entity);
                        break block0;
                    }
                    case 1: {
                        if (session.isHandsBusy()) {
                            return;
                        }
                        int entityId = entity.getDefinition() == EntityDefinitions.ENDER_DRAGON ? entity.getEntityId() + 3 : entity.getEntityId();
                        ServerboundInteractPacket attackPacket = new ServerboundInteractPacket(entityId, InteractAction.ATTACK, session.isSneaking());
                        session.sendDownstreamGamePacket(attackPacket);
                        session.sendDownstreamGamePacket(new ServerboundSwingPacket(Hand.MAIN_HAND));
                        CooldownUtils.sendCooldown(session);
                    }
                }
            }
        }
    }

    private void processEntityInteraction(GeyserSession session, InventoryTransactionPacket packet, Entity entity) {
        Vector3f entityPosition = entity.getPosition();
        if (!session.getWorldBorder().isInsideBorderBoundaries(entityPosition)) {
            return;
        }
        Vector3f clickPosition = packet.getClickPosition().sub(entityPosition);
        boolean isSpectator = session.getGameMode() == GameMode.SPECTATOR;
        for (Hand hand : EntityUtils.HANDS) {
            session.sendDownstreamGamePacket(new ServerboundInteractPacket(entity.getEntityId(), InteractAction.INTERACT_AT, clickPosition.getX(), clickPosition.getY(), clickPosition.getZ(), hand, session.isSneaking()));
            InteractionResult result = isSpectator ? InteractionResult.PASS : entity.interactAt(hand);
            if (!result.consumesAction()) {
                session.sendDownstreamGamePacket(new ServerboundInteractPacket(entity.getEntityId(), InteractAction.INTERACT, hand, session.isSneaking()));
                if (!isSpectator) {
                    result = entity.interact(hand);
                }
            }
            if (!result.consumesAction()) continue;
            if (result.shouldSwing() && hand == Hand.OFF_HAND) {
                session.sendDownstreamGamePacket(new ServerboundSwingPacket(hand));
            }
            return;
        }
    }

    public static boolean canInteractWithBlock(GeyserSession session, Vector3f playerPosition, Vector3i packetBlockPosition) {
        float diffZ;
        float diffY;
        double blockInteractionRange = session.getPlayerEntity().getBlockInteractionRange();
        double additionalRangeCheck = blockInteractionRange + 1.0;
        float minX = packetBlockPosition.getX();
        float minY = packetBlockPosition.getY();
        float minZ = packetBlockPosition.getZ();
        float maxX = packetBlockPosition.getX() + 1;
        float maxY = packetBlockPosition.getY() + 1;
        float maxZ = packetBlockPosition.getZ() + 1;
        float diffX = Math.max(Math.max(minX - playerPosition.getX(), playerPosition.getX() - maxX), 0.0f);
        return (double)(diffX * diffX + (diffY = Math.max(Math.max(minY - playerPosition.getY(), playerPosition.getY() - maxY), 0.0f)) * diffY + (diffZ = Math.max(Math.max(minZ - playerPosition.getZ(), playerPosition.getZ() - maxZ), 0.0f)) * diffZ) < additionalRangeCheck * additionalRangeCheck;
    }

    private boolean isIncorrectHeldItem(GeyserSession session, InventoryTransactionPacket packet) {
        ItemDefinition heldItemId;
        int javaSlot = session.getPlayerInventory().getOffsetForHotbar(packet.getHotbarSlot());
        ItemDefinition expectedItem = ItemTranslator.getBedrockItemDefinition(session, session.getPlayerInventory().getItem(javaSlot));
        ItemDefinition itemDefinition = heldItemId = packet.getItemInHand() == null ? ItemData.AIR.getDefinition() : packet.getItemInHand().getDefinition();
        if (!expectedItem.equals(heldItemId)) {
            session.getGeyser().getLogger().debug(session.bedrockUsername() + "'s held item has desynced! Expected: " + String.valueOf(expectedItem) + " Received: " + String.valueOf(heldItemId));
            session.getGeyser().getLogger().debug("Packet: " + String.valueOf(packet));
            return true;
        }
        return false;
    }

    private boolean useItem(GeyserSession session, InventoryTransactionPacket packet, int blockState, boolean useTouchRotation) {
        PlayerInventory playerInventory = session.getPlayerInventory();
        int heldItemSlot = playerInventory.getOffsetForHotbar(packet.getHotbarSlot());
        session.getPlayerInventoryHolder().updateSlot(heldItemSlot);
        GeyserItemStack itemStack = playerInventory.getItem(heldItemSlot);
        if (itemStack.getAmount() > 1 && (itemStack.is(Items.BUCKET) || itemStack.is(Items.GLASS_BOTTLE))) {
            for (int i = 0; i < 36; ++i) {
                int slot = i;
                if (i < 9) {
                    slot = playerInventory.getOffsetForHotbar(slot);
                }
                if (!playerInventory.getItem(slot).isEmpty()) continue;
                session.getPlayerInventoryHolder().updateSlot(slot);
                break;
            }
        }
        if (!session.isSneaking()) {
            boolean mayBuild;
            if (((BitSet)BlockRegistries.INTERACTIVE.get()).get(blockState)) {
                return false;
            }
            boolean bl = mayBuild = session.getGameMode() == GameMode.SURVIVAL || session.getGameMode() == GameMode.CREATIVE;
            if (mayBuild && ((BitSet)BlockRegistries.INTERACTIVE_MAY_BUILD.get()).get(blockState)) {
                return false;
            }
        }
        session.useItem(Hand.MAIN_HAND, useTouchRotation);
        return true;
    }
}

